/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matrix
extends Controller<Matrix> {
    protected int cnt;
    protected int[][] _myCells;
    protected int stepX;
    protected int stepY;
    protected int cellX;
    protected int cellY;
    protected boolean isPressed;
    protected int _myCellX;
    protected int _myCellY;
    protected int sum;
    protected int _myInterval = 100;
    protected int currentX = -1;
    protected int currentY = -1;
    protected int _myMode = 1;
    private Thread t;
    protected int gapX = 1;
    protected int gapY = 1;
    private Object _myPlug;
    private String _myPlugName;

    public Matrix(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 10, 10, 0, 0, 100, 100);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public Matrix(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, int theCellX, int theCellY, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this.setGrid(theCellX, theCellY);
        this._myPlug = this.cp5.papplet;
        this._myPlugName = this.getName();
        this._myCaptionLabel.align(37, 13);
        this._myCaptionLabel.setPadding(0, 4);
        this.runThread();
    }

    public Matrix setGrid(int theCellX, int theCellY) {
        this._myCellX = theCellX;
        this._myCellY = theCellY;
        this.sum = this._myCellX * this._myCellY;
        this.stepX = this.width / this._myCellX;
        this.stepY = this.height / this._myCellY;
        this._myCells = new int[this._myCellX][this._myCellY];
        for (int x = 0; x < this._myCellX; ++x) {
            for (int y = 0; y < this._myCellY; ++y) {
                this._myCells[x][y] = 0;
            }
        }
        return this;
    }

    public Matrix setInterval(int theInterval) {
        this._myInterval = theInterval;
        return this;
    }

    public int getInterval() {
        return this._myInterval;
    }

    @Override
    @ControlP5.Invisible
    public Matrix updateInternalEvents(PApplet theApplet) {
        this.setIsInside(this.inside());
        if (this.getIsInside() && this.isPressed) {
            int tX = (int)(((float)theApplet.mouseX - this.position.x) / (float)this.stepX);
            int tY = (int)(((float)theApplet.mouseY - this.position.y) / (float)this.stepY);
            if (tX != this.currentX || tY != this.currentY) {
                boolean isMarkerActive = this._myCells[tX = PApplet.min((int)PApplet.max((int)0, (int)tX), (int)this._myCellX)][tY = PApplet.min((int)PApplet.max((int)0, (int)tY), (int)this._myCellY)] == 1;
                switch (this._myMode) {
                    default: {
                        for (int i = 0; i < this._myCellY; ++i) {
                            this._myCells[tX][i] = 0;
                        }
                        this._myCells[tX][tY] = !isMarkerActive ? 1 : this._myCells[tX][tY];
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this._myCellY; ++i) {
                            this._myCells[tX][i] = 0;
                        }
                        this._myCells[tX][tY] = !isMarkerActive ? 1 : this._myCells[tX][tY];
                        break;
                    }
                    case 2: {
                        this._myCells[tX][tY] = this._myCells[tX][tY] == 1 ? 0 : 1;
                    }
                }
                this.currentX = tX;
                this.currentY = tY;
            }
        }
        return this;
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.isActive = this.getIsInside();
        if (this.getIsInside()) {
            this.isPressed = true;
        }
    }

    @Override
    protected void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        if (this.isActive) {
            this.isActive = false;
        }
        this.isPressed = false;
        this.currentX = -1;
        this.currentY = -1;
    }

    @Override
    public Matrix setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this;
    }

    @Override
    public Matrix update() {
        return this.setValue(this._myValue);
    }

    public Matrix setGap(int theX, int theY) {
        this.gapX = theX;
        this.gapY = theY;
        return this;
    }

    @Override
    public Matrix plugTo(Object theObject) {
        this._myPlug = theObject;
        return this;
    }

    @Override
    public Matrix plugTo(Object theObject, String thePlugName) {
        this._myPlug = theObject;
        this._myPlugName = thePlugName;
        return this;
    }

    public Matrix set(int theX, int theY, boolean theValue) {
        this._myCells[theX][theY] = theValue ? 1 : 0;
        return this;
    }

    public boolean get(int theX, int theY) {
        return this._myCells[theX][theY] == 1;
    }

    public Matrix clear() {
        for (int x = 0; x < this._myCells.length; ++x) {
            for (int y = 0; y < this._myCells[x].length; ++y) {
                this._myCells[x][y] = 0;
            }
        }
        return this;
    }

    public static int getX(int thePosition) {
        return thePosition >> 0 & 0xFF;
    }

    public static int getY(int thePosition) {
        return thePosition >> 8 & 0xFF;
    }

    public static int getX(float thePosition) {
        return (int)thePosition >> 0 & 0xFF;
    }

    public static int getY(float thePosition) {
        return (int)thePosition >> 8 & 0xFF;
    }

    public Matrix setCells(int[][] theCells) {
        this.setGrid(theCells.length, theCells[0].length);
        this._myCells = theCells;
        return this;
    }

    public int[][] getCells() {
        return this._myCells;
    }

    private void triggerEventFromThread() {
        ++this.cnt;
        this.cnt %= this._myCellX;
        for (int i = 0; i < this._myCellY; ++i) {
            if (this._myCells[this.cnt][i] != 1) continue;
            this._myValue = 0.0f;
            this._myValue = (this.cnt << 0) + (i << 8);
            this.setValue(this._myValue);
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                method.invoke(this._myPlug, this.cnt, i);
                continue;
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void runThread() {
        if (this.t == null) {
            this.t = new Thread(this.getName()){

                public void run() {
                    while (true) {
                        Matrix.this.triggerEventFromThread();
                        try {
                            1.sleep(Matrix.this._myInterval);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            this.t.start();
        }
    }

    @Override
    public void remove() {
        if (this.t != null) {
            this.t.interrupt();
        }
        super.remove();
    }

    public Matrix setMode(int theMode) {
        this._myMode = theMode;
        return this;
    }

    public int getMode() {
        return this._myMode;
    }

    @Override
    @ControlP5.Invisible
    public Matrix updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new MatrixView();
                break;
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MatrixView
    implements ControllerView<Matrix> {
        MatrixView() {
        }

        @Override
        public void display(PApplet theApplet, Matrix theController) {
            int y;
            int x;
            theApplet.noStroke();
            for (x = 0; x < Matrix.this._myCellX; ++x) {
                for (y = 0; y < Matrix.this._myCellY; ++y) {
                    if (Matrix.this._myCells[x][y] == 1) {
                        theApplet.fill(Matrix.this.color.getActive());
                        theApplet.rect((float)(x * Matrix.this.stepX), (float)(y * Matrix.this.stepY), (float)(Matrix.this.stepX - Matrix.this.gapX), (float)(Matrix.this.stepY - Matrix.this.gapY));
                        continue;
                    }
                    theApplet.fill(Matrix.this.color.getBackground());
                    theApplet.rect((float)(x * Matrix.this.stepX), (float)(y * Matrix.this.stepY), (float)(Matrix.this.stepX - Matrix.this.gapX), (float)(Matrix.this.stepY - Matrix.this.gapY));
                }
            }
            if (Matrix.this.isInside()) {
                x = (int)(((float)theApplet.mouseX - Matrix.this.position.x) / (float)Matrix.this.stepX);
                y = (int)(((float)theApplet.mouseY - Matrix.this.position.y) / (float)Matrix.this.stepY);
                if (x >= 0 && x < Matrix.this._myCellX && y >= 0 && y < Matrix.this._myCellY) {
                    theApplet.fill(Matrix.this._myCells[x][y] == 1 ? Matrix.this.color.getActive() : Matrix.this.color.getForeground());
                    theApplet.rect((float)(x * Matrix.this.stepX), (float)(y * Matrix.this.stepY), (float)(Matrix.this.stepX - Matrix.this.gapX), (float)(Matrix.this.stepY - Matrix.this.gapY));
                }
            }
            theApplet.fill(Matrix.this.color.getActive());
            theApplet.rect((float)(Matrix.this.cnt * Matrix.this.stepX), 0.0f, 1.0f, (float)(Matrix.this.height - Matrix.this.gapY));
            if (Matrix.this.isLabelVisible) {
                Matrix.this._myCaptionLabel.draw(theApplet, 0, 0, theController);
            }
        }
    }
}

