/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.Label;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PImage;

public class BitFontRenderer {
    protected static int numFonts = 4;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    protected float height;
    protected static Map<Integer, BitFont> fonts;
    private final ControlP5 cp5;

    protected BitFontRenderer(ControlP5 theControlP5) {
        this.cp5 = theControlP5;
        this.loadFonts();
    }

    private void loadFonts() {
        if (fonts == null) {
            fonts = new HashMap<Integer, BitFont>();
            fonts.put(0, new BitFont(0).setSource("standard58.gif"));
            fonts.put(1, new BitFont(1).setSource("standard56.gif"));
            fonts.put(2, new BitFont(2).setSource("synt24.gif"));
            fonts.put(3, new BitFont(3).setSource("GrixelKyrou9.gif"));
        }
    }

    public static int addBitFont(PImage theImage) {
        ControlP5.logger.info("adding custom bitfonts is disabled with this version of controlP5.");
        return -1;
    }

    protected static BitFont getFont(int theIndex) {
        return fonts.get(theIndex);
    }

    protected static int getPosition(Label theLabel, ControlFont.BitFontLabel theBitFont, int theX) {
        BitFont f = fonts.get(theBitFont.getFontIndex());
        String s = theLabel.getTextFormatted();
        int l = s.length();
        int x = 0;
        for (int i = 0; i < l; ++i) {
            int myIndex = s.charAt(i) - 32;
            if (myIndex < 0 || myIndex > 95 || (x += f.charWidth[myIndex] + theLabel.getLetterSpacing()) < theX) continue;
            return i;
        }
        return l;
    }

    public static int getWidth(Label theLabel, ControlFont.BitFontLabel theBitFont, String theText) {
        return BitFontRenderer.getDimension(theLabel, theBitFont, -1, -1, theText, 0, theText.length())[0];
    }

    public static int getWidth(Label theLabel, ControlFont.BitFontLabel theBitFont) {
        return BitFontRenderer.getWidth(theLabel, theBitFont, theLabel.getText().length());
    }

    protected static int getWidth(Label theLabel, ControlFont.BitFontLabel theBitFont, int theLength) {
        return BitFontRenderer.getDimension(theLabel, theBitFont, -1, -1, theLabel.getTextFormatted(), 0, theLength)[0];
    }

    protected static int[] getDimension(Label theLabel, ControlFont.BitFontLabel theBitFont, String theText) {
        return BitFontRenderer.getDimension(theLabel, theBitFont, -1, -1, theText, 0, theText.length());
    }

    protected static int[] getDimension(Label theLabel, ControlFont.BitFontLabel theBitFont, int theWidth, int theHeight, String theText, int theStart, int theEnd) {
        int[] dim = new int[]{0, theLabel.getLineHeight()};
        int tx = 0;
        BitFont f = fonts.get(theBitFont.getFontIndex());
        theEnd = PApplet.min((int)theText.length(), (int)theEnd);
        for (int i = theStart; i < theEnd; ++i) {
            int myIndex = theText.charAt(i) - 32;
            if (myIndex >= 0 && myIndex <= 95) {
                dim[0] = dim[0] + (f.charWidth[myIndex] + theLabel.getLetterSpacing());
                continue;
            }
            char c = theText.charAt(i);
            if (c != '\t' && c != '\n' && c != '\r') {
                ControlP5.logger().warning("You are using a character that is not supported by controlP5's BitFont-Renderer, you could use ControlFont instead (see the ControlP5controlFont example). (" + theText.charAt(i) + "," + theText.charAt(i) + ")");
                continue;
            }
            if (dim[0] > tx) {
                tx = dim[0];
                dim[0] = 0;
            }
            if (c != '\n' && c != '\r') continue;
            dim[1] = dim[1] + theLabel.getLineHeight();
        }
        dim[0] = dim[0] > tx ? dim[0] : tx;
        return dim;
    }

    public static int getHeight(int theFontIndex) {
        return BitFontRenderer.fonts.get((Object)Integer.valueOf((int)theFontIndex)).texture.height;
    }

    public static int getHeight(ControlFont.BitFontLabel theLabel) {
        return BitFontRenderer.fonts.get((Object)Integer.valueOf((int)theLabel.getFontIndex())).texture.height;
    }

    private static void putchar(int theC, int theX, int theY, int theColor, PImage theImage, PImage theMask, BitFont theBitFont) {
        int myWH = theImage.width * theImage.height;
        int len = theBitFont.charWidth[theC] * theBitFont.charHeight;
        int w = theY * theImage.width;
        for (int i = 0; i < len; ++i) {
            int xpos = theX + i % theBitFont.charWidth[theC];
            int pos = xpos + w + i / theBitFont.charWidth[theC] * theImage.width;
            if (theBitFont.chars[theC][i] != -16777216 || xpos >= theImage.width || xpos < 0 || pos < 0 || pos >= myWH) continue;
            theImage.pixels[pos] = theColor;
            theMask.pixels[pos] = -1;
        }
    }

    private static int writeCharacters(ControlFont.BitFontLabel theBitFont, Label theLabel) {
        int i;
        BitFont f = fonts.get(theBitFont.getFontIndex());
        int indent = 0;
        if (theLabel.isFixedSize()) {
            int n = BitFontRenderer.getWidth(theLabel, theBitFont);
            indent = n > theLabel.getWidth() ? theLabel.getWidth() - n : 0;
        }
        int myOriginalY = theLabel.getFont().get().getOffset(1);
        int myY = theLabel.getFont().get().getOffset(1);
        String s = theLabel.getTextFormatted();
        int myWrap = theLabel.isMultiline() ? theBitFont.getImage().width : -1;
        int l = s.length();
        int[] letters_indent = new int[l];
        int[] letters_letter = new int[l];
        int[] letters_lineheight = new int[l];
        int err = 0;
        for (i = 0; i < l; ++i) {
            int c = s.charAt(i);
            if (c != 10) {
                if (myWrap > 0 && indent > myWrap) {
                    indent = 0;
                    myY += theLabel.getLineHeight();
                    int j = i;
                    ++err;
                    while (i > 0 && err < s.length()) {
                        if (--i == 1) {
                            i = j;
                            break;
                        }
                        if (s.charAt(i) != ' ' && s.charAt(i) != '-') continue;
                        c = s.charAt(++i);
                        break;
                    }
                }
                if (c >= 127 || c <= 32) {
                    c = 32;
                }
                letters_indent[i] = indent;
                letters_letter[i] = c - 32;
                letters_lineheight[i] = myY;
                indent += f.charWidth[c - 32] + theLabel.getLetterSpacing();
                continue;
            }
            myY += theLabel.getLineHeight();
            indent = 0;
            letters_indent[i] = 0;
            letters_letter[i] = -1;
            letters_lineheight[i] = 0;
        }
        for (i = 0; i < l; ++i) {
            if (letters_letter[i] == -1) continue;
            BitFontRenderer.putchar(letters_letter[i], letters_indent[i], letters_lineheight[i], theLabel.getColor(), theBitFont.getImage(), theBitFont.getImageMask(), f);
        }
        return myY - myOriginalY;
    }

    public static int write(ControlFont.BitFontLabel theBitFont, Label theLabel) {
        int myWH = theBitFont.getImage().width * theBitFont.getImage().height;
        for (int i = 0; i < myWH; ++i) {
            theBitFont.getImage().pixels[i] = 0xFFFFFF;
            theBitFont.getImageMask().pixels[i] = -16777216;
        }
        int myHeight = BitFontRenderer.writeCharacters(theBitFont, theLabel);
        theBitFont.getImage().mask(theBitFont.getImageMask());
        return myHeight;
    }

    @Deprecated
    public static int getWidth(ControlFont.BitFontLabel theLabel) {
        return -1;
    }

    class BitFont {
        protected int characters;
        protected int[] charWidth = new int[255];
        protected int charHeight;
        protected int[][] chars;
        protected int lineHeight;
        protected int wh;
        protected PImage texture;
        protected int id;
        private String _mySource;

        BitFont(int theId) {
            this.id = theId;
        }

        int getHeight() {
            return this.texture.height;
        }

        BitFont setSource(String theSource) {
            this._mySource = theSource;
            this.texture = ((BitFontRenderer)BitFontRenderer.this).cp5.papplet.loadImage(this.getClass().getResource(this._mySource).toString());
            this.lineHeight = this.charHeight = this.texture.height;
            int currWidth = 0;
            int maxWidth = 0;
            for (int i = 0; i < this.texture.width; ++i) {
                ++currWidth;
                if (this.texture.pixels[i] != -65536) continue;
                this.charWidth[this.characters] = currWidth;
                ++this.characters;
                if (currWidth > maxWidth) {
                    maxWidth = currWidth;
                }
                currWidth = 0;
            }
            this.chars = new int[this.characters][maxWidth * this.charHeight];
            int indent = 0;
            for (int i = 0; i < this.characters; ++i) {
                for (int u = 0; u < this.charWidth[i] * this.charHeight; ++u) {
                    this.chars[i][u] = this.texture.pixels[indent + u / this.charWidth[i] * this.texture.width + u % this.charWidth[i]];
                }
                indent += this.charWidth[i];
            }
            return this;
        }
    }
}

