/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Bang;
import controlP5.ControlElement;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.Knob;
import controlP5.Numberbox;
import controlP5.Slider;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControllerAutomator {
    static Map<Set<Class<?>>, Class<? extends Controller<?>>> mapping = new HashMap();
    static Map<String, Class<? extends Controller<?>>> types;
    private ControlP5 cp5;

    static Set<Class<?>> makeKey(Class<?> ... cs) {
        HashSet set = new HashSet();
        for (Class<?> c : cs) {
            set.add(c);
        }
        return set;
    }

    ControllerAutomator(ControlP5 c) {
        this.cp5 = c;
    }

    private Object[] getParameters(Class<?>[] cs, String v) {
        if (cs[0] == Integer.TYPE) {
            return new Object[]{Integer.parseInt(v)};
        }
        if (cs[0] == Float.TYPE) {
            return new Object[]{Float.valueOf(Float.parseFloat(v))};
        }
        if (cs[0] == String.class) {
            return new Object[]{v};
        }
        if (cs[0] == Boolean.TYPE) {
            return new Object[]{Boolean.parseBoolean(v)};
        }
        return new Object[0];
    }

    void addControllersFor(String theAddressSpace, Object t) {
        String[] a;
        Class<? extends Controller<?>> type;
        HashMap<String, String> params;
        ControlElement ce;
        if (t instanceof List) {
            return;
        }
        Class<?> c = t.getClass();
        Field[] fs = c.getDeclaredFields();
        Method[] ms = c.getDeclaredMethods();
        for (Method method : ms) {
            if (!method.isAnnotationPresent(ControlElement.class)) continue;
            ce = method.getAnnotation(ControlElement.class);
            params = new HashMap<String, String>();
            type = null;
            for (String s : ce.properties()) {
                a = PApplet.split((String)s, (String)"=");
                if (a[0].startsWith("type")) {
                    type = types.get(a[1].toLowerCase());
                    continue;
                }
                params.put("set" + ControllerAutomator.capitalize(a[0]), a[1]);
            }
            if (type == null) {
                type = mapping.get(ControllerAutomator.makeKey(method.getParameterTypes()));
            }
            if (type == null) continue;
            this.cp5.addController(t, theAddressSpace, method.getName(), type, ce.x(), ce.y());
        }
        for (AccessibleObject accessibleObject : fs) {
            Controller cntr;
            block28: {
                if (!accessibleObject.isAnnotationPresent(ControlElement.class)) continue;
                ce = ((Field)accessibleObject).getAnnotation(ControlElement.class);
                params = new HashMap();
                type = null;
                for (String s : ce.properties()) {
                    a = PApplet.split((String)s, (String)"=");
                    if (a[0].startsWith("type")) {
                        type = types.get(a[1].toLowerCase());
                        continue;
                    }
                    params.put("set" + ControllerAutomator.capitalize(a[0]), a[1]);
                }
                cntr = null;
                ((Field)accessibleObject).setAccessible(true);
                if (((Field)accessibleObject).getType() == Float.TYPE || ((Field)accessibleObject).getType() == Integer.TYPE) {
                    cntr = type == Knob.class ? this.cp5.addKnob(t, theAddressSpace, ((Field)accessibleObject).getName()) : (type == Numberbox.class ? this.cp5.addNumberbox(t, theAddressSpace, ((Field)accessibleObject).getName()) : this.cp5.addSlider(t, theAddressSpace, ((Field)accessibleObject).getName()));
                    try {
                        if (((Field)accessibleObject).getType() == Float.TYPE) {
                            cntr.setValue(((Field)accessibleObject).getFloat(t));
                            break block28;
                        }
                        cntr.setValue(((Field)accessibleObject).getInt(t));
                    }
                    catch (Exception e) {
                        ControlP5.logger.severe(e.toString());
                    }
                } else if (((Field)accessibleObject).getType() == String.class) {
                    if (type == Textlabel.class) {
                        String s = "";
                        try {
                            s = "" + ((Field)accessibleObject).get(t);
                            if (((Field)accessibleObject).get(t) == null) {
                                s = ce.label();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        cntr = this.cp5.addTextlabel(t, theAddressSpace, ((Field)accessibleObject).getName(), s);
                    } else {
                        cntr = this.cp5.addTextfield(t, theAddressSpace, ((Field)accessibleObject).getName());
                    }
                } else if (((Field)accessibleObject).getType() == Boolean.TYPE) {
                    cntr = this.cp5.addToggle(t, theAddressSpace, ((Field)accessibleObject).getName());
                    try {
                        cntr.setValue(((Field)accessibleObject).getBoolean(t) ? 1.0f : 0.0f);
                    }
                    catch (Exception e) {
                        ControlP5.logger.severe(e.toString());
                    }
                }
            }
            if (cntr == null) continue;
            if (ce.label().length() > 0) {
                cntr.setCaptionLabel(ce.label());
            }
            cntr.setPosition(ce.x(), ce.y());
            Set keys = params.keySet();
            for (String k : keys) {
                String v = (String)params.get(k);
                for (Method method : cntr.getClass().getMethods()) {
                    if (!method.getName().equals(k)) continue;
                    try {
                        Object[] os = this.getParameters(method.getParameterTypes(), v);
                        method.invoke((Object)cntr, os);
                    }
                    catch (Exception e) {
                        ControlP5.logger.severe(e.toString());
                    }
                }
            }
        }
    }

    static String capitalize(String theString) {
        StringBuilder result = new StringBuilder(theString.length());
        String[] words = theString.split("\\s");
        int l = words.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(words[i].charAt(0))).append(words[i].substring(1));
        }
        return result.toString();
    }

    static {
        mapping.put(ControllerAutomator.makeKey(Boolean.TYPE), Toggle.class);
        mapping.put(ControllerAutomator.makeKey(Integer.TYPE), Slider.class);
        mapping.put(ControllerAutomator.makeKey(Float.TYPE), Slider.class);
        mapping.put(ControllerAutomator.makeKey(String.class), Textfield.class);
        types = new HashMap();
        types.put("slider", Slider.class);
        types.put("knob", Knob.class);
        types.put("numberbox", Numberbox.class);
        types.put("toggle", Toggle.class);
        types.put("bang", Bang.class);
        types.put("toggle", Toggle.class);
        types.put("textfield", Textfield.class);
        types.put("label", Textlabel.class);
        types.put("textlabel", Textlabel.class);
    }
}

