/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.FieldValue;
import java.lang.reflect.Field;

class FieldChangedListener {
    private FieldValue value;
    private ControlP5 controlP5;

    public FieldChangedListener(ControlP5 theControlP5) {
        this.controlP5 = theControlP5;
    }

    public void listenTo(final Object theObject, final String theFieldName) {
        try {
            Class<?> c = theObject.getClass();
            final Field field = c.getDeclaredField(theFieldName);
            field.setAccessible(true);
            if (field.getType().isAssignableFrom(Float.TYPE)) {
                this.value = new FieldValue(){
                    float then;

                    public void check() {
                        try {
                            float now = ((Float)field.get(theObject)).floatValue();
                            if (now != this.then) {
                                FieldChangedListener.this.controlP5.getController(theFieldName, theObject).setValue(now);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(Integer.TYPE)) {
                this.value = new FieldValue(){
                    int then;

                    public void check() {
                        try {
                            int now = (Integer)field.get(theObject);
                            if (now != this.then) {
                                FieldChangedListener.this.controlP5.getController(theFieldName, theObject).setValue(now);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                this.value = new FieldValue(){
                    boolean then;

                    public void check() {
                        try {
                            boolean now = (Boolean)field.get(theObject);
                            if (now != this.then) {
                                FieldChangedListener.this.controlP5.getController(theFieldName, theObject).setValue(now ? 1.0f : 0.0f);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(String.class)) {
                this.value = new FieldValue(){
                    String then;

                    public void check() {
                        try {
                            String now = (String)field.get(theObject);
                            if (!now.equals(this.then)) {
                                FieldChangedListener.this.controlP5.getController(theFieldName, theObject).setStringValue(now);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void update() {
        this.value.check();
    }
}

