/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.CRect;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.MultiList;
import controlP5.MultiListInterface;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiListButton
extends Button
implements MultiListInterface {
    private List<MultiListButton> _myChildren = new ArrayList<MultiListButton>();
    private MultiListInterface parent;
    private MultiList root;
    private CRect _myRect;
    protected int _myDirection = 39;
    private boolean isUpperCase = true;

    protected MultiListButton(ControlP5 theControlP5, String theName, float theValue, int theX, int theY, int theWidth, int theHeight, MultiListInterface theParent, MultiList theRoot) {
        super(theControlP5, (ControllerGroup)theRoot.getParent(), theName, theValue, theX, theY, theWidth, theHeight);
        this.parent = theParent;
        this.root = theRoot;
        this.updateRect(this.position.x, this.position.y, this.width, this.height);
        this._myCaptionLabel.align(37, 3);
    }

    @Override
    public MultiListButton toUpperCase(boolean theValue) {
        this.isUpperCase = theValue;
        for (MultiListButton c : this._myChildren) {
            c.toUpperCase(this.isUpperCase);
        }
        this._myCaptionLabel.toUpperCase(this.isUpperCase);
        return this;
    }

    @Override
    public void remove() {
        int i;
        int myYoffset = 0;
        for (i = 0; i < this.parent.getChildren().size(); ++i) {
            if (this.parent.getChildren().get(i) == this) {
                myYoffset = this.height + 1;
            }
            ((MultiListButton)this.parent.getChildren().get(i)).updateLocation(0.0f, -myYoffset);
        }
        if (this._myParent != null) {
            this.removeListener(this.root);
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.removeListener(this.root);
            this.cp5.remove(this);
        }
        for (i = 0; i < this._myChildren.size(); ++i) {
            this._myChildren.get(i).remove();
        }
    }

    public List<MultiListButton> getChildren() {
        return this._myChildren;
    }

    @Override
    public int getDirection() {
        return this._myDirection;
    }

    protected void setDirection(int theDirection) {
        this._myDirection = theDirection;
    }

    public void updateRect(float theX, float theY, float theW, float theH) {
        this._myRect = new CRect(theX, theY, theW, theH);
    }

    @Override
    public void updateLocation(float theX, float theY) {
        this.position.x += theX;
        this.position.y += theY;
        this.updateRect(this.position.x, this.position.y, this.width, this.height);
        for (int i = 0; i < this._myChildren.size(); ++i) {
            ((MultiListInterface)this._myChildren.get(i)).updateLocation(theX, theY);
        }
    }

    @Override
    public MultiListButton setWidth(int theWidth) {
        int dif = this._myDirection == 37 ? theWidth - this.width : 0;
        this.width = theWidth;
        this.updateLocation(-dif, 0.0f);
        return this;
    }

    @Override
    public MultiListButton setHeight(int theHeight) {
        int difHeight = this.height;
        this.height = theHeight;
        difHeight = this.height - difHeight;
        int myYoffset = 0;
        for (int i = 0; i < this.parent.getChildren().size(); ++i) {
            this.parent.getChildren().get(i).updateLocation(0.0f, myYoffset);
            if (this.parent.getChildren().get(i) != this) continue;
            myYoffset = difHeight;
        }
        this.updateLocation(0.0f, 0.0f);
        return this;
    }

    public MultiListButton add(String theName, float theValue) {
        int myHeight = -(this.height + 1);
        for (int i = 0; i < this.getChildren().size(); ++i) {
            myHeight += this.getChildren().get((int)i).height + 1;
        }
        int xx = (int)this.position.x + (this.width + 1);
        MultiListButton b = new MultiListButton(this.cp5, theName, theValue, xx, (int)this.position.y + (this.height + 1) + myHeight, this.width, this.height, this, this.root);
        b.isMoveable = false;
        b.toUpperCase(this.isUpperCase);
        b.hide();
        this.cp5.register(null, "", b);
        b.addListener(this.root);
        this._myChildren.add(b);
        this.updateRect(xx, this.position.y, this.width, this.height + 1 + myHeight);
        return b;
    }

    @Override
    protected void onEnter() {
        if (!this.root.isUpdateLocation) {
            this.isActive = true;
            this.root.occupied(true);
            this.root.mostRecent = this;
            this.parent.close(this);
            this.open();
        }
    }

    @Override
    protected void onLeave() {
        if (!this.parent.observe() && !this.root.isUpdateLocation && this.root.mostRecent == this) {
            this.isActive = false;
            this.root.occupied(false);
        }
    }

    @Override
    public void mouseReleasedOutside() {
    }

    @Override
    public boolean observe() {
        return CRect.inside(this._myRect, this._myControlWindow.mouseX, this._myControlWindow.mouseY);
    }

    @Override
    public void close(MultiListInterface theInterface) {
        for (int i = 0; i < this._myChildren.size(); ++i) {
            if (theInterface == (MultiListInterface)this._myChildren.get(i)) continue;
            ((MultiListInterface)this._myChildren.get(i)).close();
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this._myChildren.size(); ++i) {
            this._myChildren.get(i).close();
            this._myChildren.get(i).hide();
        }
    }

    @Override
    public void open() {
        for (int i = 0; i < this._myChildren.size(); ++i) {
            this._myChildren.get(i).show();
        }
    }
}

