/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.CColor;
import controlP5.CallbackListener;
import controlP5.ControlBroadcaster;
import controlP5.ControlFont;
import controlP5.ControlKey;
import controlP5.ControlListener;
import controlP5.ControlP5Base;
import controlP5.ControlP5IOHandler;
import controlP5.ControlWindow;
import controlP5.ControlWindowCanvas;
import controlP5.ControlWindowKeyHandler;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerProperty;
import controlP5.FieldChangedListener;
import controlP5.Tab;
import controlP5.Textfield;
import controlP5.Tooltip;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlP5
extends ControlP5Base {
    @Invisible
    public ControlWindow controlWindow;
    public static final CColor RETRO = new CColor(-16750196, -16763310, -16211249, -1, -1);
    public static final CColor CP5BLUE = new CColor(-16683874, -16632755, -16730902, -1, -1);
    public static final CColor RED = new CColor(-5636096, -10092544, -65536, -1, -1);
    public static final CColor WHITE = new CColor(-1711276033, 0x55FFFFFF, -1, -1, -1);
    @Invisible
    static CColor color = new CColor(CP5BLUE);
    @Invisible
    public ControlWindowKeyHandler keyHandler;
    @Invisible
    public PApplet papplet;
    @Invisible
    public static final String VERSION = "0.7.5";
    @Invisible
    public static boolean isApplet;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    public static boolean DEBUG;
    @Invisible
    public static final Logger logger;
    private Map<String, ControllerInterface<?>> _myControllerMap;
    protected ControlBroadcaster _myControlBroadcaster;
    protected Vector<ControlWindow> controlWindowList = new Vector();
    protected boolean isMoveable = false;
    protected boolean isAutoInitialization = false;
    protected boolean isGlobalControllersAlwaysVisible = true;
    protected ControlP5IOHandler _myControlP5IOHandler;
    protected boolean isTabEventsActive;
    protected boolean isUpdate;
    protected boolean isControlFont;
    protected ControlFont controlFont;
    protected static int bitFont;
    protected boolean isShortcuts = false;
    protected boolean blockDraw;
    protected Tooltip _myTooltip;
    protected boolean isAnnotation;
    static int welcome;

    public ControlP5(PApplet theParent) {
        this.papplet = theParent;
        this.init();
    }

    public ControlP5(PApplet theParent, ControlFont theControlFont) {
        this.papplet = theParent;
        this.setFont(theControlFont);
        this.init();
    }

    protected void init() {
        new BitFontRenderer(this);
        this.isTabEventsActive = false;
        this._myControlP5IOHandler = new ControlP5IOHandler(this);
        this._myControlBroadcaster = new ControlBroadcaster(this);
        this.keyHandler = new ControlWindowKeyHandler(this);
        this.controlWindow = new ControlWindow(this, this.papplet);
        this.papplet.registerPre((Object)this);
        this.papplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
        this.papplet.registerDispose((Object)this);
        this._myControllerMap = new TreeMap();
        this.controlWindowList.add(this.controlWindow);
        isApplet = this.papplet.online;
        this._myTooltip = new Tooltip(this);
        super.init(this);
        if (welcome++ < 1) {
            this.welcome();
        }
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                ControlP5.this.saveProperties();
            }
        }, 18, 16, 115);
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                ControlP5.this.loadProperties();
            }
        }, 18, 16, 108);
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                if (ControlP5.this.controlWindow.isVisible) {
                    ControlP5.this.hide();
                } else {
                    ControlP5.this.show();
                }
            }
        }, 18, 16, 104);
    }

    private void welcome() {
        System.out.println("ControlP5 0.7.5 infos, comments, questions at http://www.sojamo.de/libraries/controlP5");
    }

    public void setTabEventsActive(boolean theFlag) {
        this.isTabEventsActive = theFlag;
    }

    public void setAutoInitialization(boolean theFlag) {
        this.isAutoInitialization = theFlag;
    }

    public void setAutoDraw(boolean theFlag) {
        if (this.isAutoDraw() && !theFlag) {
            this.controlWindow.papplet().unregisterDraw((Object)this.controlWindow);
        }
        if (!this.isAutoDraw() && theFlag) {
            this.controlWindow.papplet().registerDraw((Object)this.controlWindow);
        }
        this.controlWindow.isAutoDraw = theFlag;
    }

    public boolean isAutoDraw() {
        return this.controlWindow.isAutoDraw;
    }

    public ControlBroadcaster getControlBroadcaster() {
        return this._myControlBroadcaster;
    }

    public ControlP5 addListener(ControlListener ... theListeners) {
        this.getControlBroadcaster().addListener(theListeners);
        return this;
    }

    public ControlP5 removeListener(ControlListener ... theListeners) {
        this.getControlBroadcaster().removeListener(theListeners);
        return this;
    }

    public ControlP5 removeListener(ControlListener theListener) {
        this.getControlBroadcaster().removeListener(theListener);
        return this;
    }

    public ControlListener getListener(int theIndex) {
        return this.getControlBroadcaster().getListener(theIndex);
    }

    public ControlP5 addCallback(CallbackListener ... theListeners) {
        this.getControlBroadcaster().addCallback(theListeners);
        return this;
    }

    public ControlP5 addCallback(CallbackListener theListener) {
        this.getControlBroadcaster().addCallback(theListener);
        return this;
    }

    public ControlP5 addCallback(CallbackListener theListener, Controller<?> ... theControllers) {
        this.getControlBroadcaster().addCallback(theListener, theControllers);
        return this;
    }

    public ControlP5 removeCallback(CallbackListener ... theListeners) {
        this.getControlBroadcaster().removeCallback(theListeners);
        return this;
    }

    public ControlP5 removeCallback(Controller<?> ... theControllers) {
        this.getControlBroadcaster().removeCallback(theControllers);
        return this;
    }

    public ControlP5 removeCallback(Controller<?> theController) {
        this.getControlBroadcaster().removeCallback(theController);
        return this;
    }

    public void addControlsFor(Object theObject) {
    }

    public Tab getTab(String theName) {
        for (int j = 0; j < this.controlWindowList.size(); ++j) {
            for (int i = 0; i < this.controlWindowList.get(j).getTabs().size(); ++i) {
                if (!((Tab)this.controlWindowList.get(j).getTabs().get(i)).getName().equals(theName)) continue;
                return (Tab)this.controlWindowList.get(j).getTabs().get(i);
            }
        }
        Tab myTab = this.addTab(theName);
        return myTab;
    }

    public Tab getTab(ControlWindow theWindow, String theName) {
        for (int i = 0; i < theWindow.getTabs().size(); ++i) {
            if (!((Tab)theWindow.getTabs().get(i)).getName().equals(theName)) continue;
            return (Tab)theWindow.getTabs().get(i);
        }
        Tab myTab = theWindow.add(new Tab(this, theWindow, theName));
        return myTab;
    }

    public ControlP5 register(Object theObject, String theIndex, ControllerInterface<?> theController) {
        String address = "";
        if (theObject == this.papplet) {
            address = theController.getName().startsWith("/") ? "" : "/";
            address = address + theController.getName();
        } else {
            address = theIndex.length() == 0 || theIndex.startsWith("/") ? "" : "/";
            address = address + theIndex;
            address = address + (theController.getName().startsWith("/") ? "" : "/");
            address = address + theController.getName();
        }
        theController.setAddress(address);
        if (this.checkName(theController.getAddress())) {
            this.remove(theController.getAddress());
        }
        this._myControllerMap.put(theController.getAddress(), theController);
        List<ControllerProperty> ps = this.getProperties().get(theController);
        if (ps != null) {
            for (ControllerProperty p : ps) {
                p.setAddress(theController.getAddress());
            }
        }
        theController.init();
        if (theController instanceof Controller) {
            if (theObject == null) {
                theObject = this.papplet;
            }
            if (!theObject.equals(this.papplet)) {
                ((Controller)((Controller)theController).unplugFrom(this.papplet)).plugTo(theObject);
            }
            if (!this._myObjectToControllerMap.containsKey(theObject)) {
                this._myObjectToControllerMap.put(theObject, new ArrayList());
            }
            ((ArrayList)this._myObjectToControllerMap.get(theObject)).add(theController);
        }
        return this;
    }

    public List<ControllerInterface<?>> getAll() {
        return new ArrayList(this._myControllerMap.values());
    }

    public <T> List<T> getAll(Class<T> theClass) {
        ArrayList l = new ArrayList();
        for (ControllerInterface<?> ci : this._myControllerMap.values()) {
            if (ci.getClass() != theClass && ci.getClass().getSuperclass() != theClass) continue;
            l.add(ci);
        }
        return l;
    }

    protected void deactivateControllers() {
        if (this.getControllerList() != null) {
            ControllerInterface<?>[] n = this.getControllerList();
            for (int i = 0; i < n.length; ++i) {
                if (!(n[i] instanceof Textfield)) continue;
                ((Textfield)n[i]).setFocus(false);
            }
        }
    }

    private String checkAddress(String theName) {
        if (!theName.startsWith("/")) {
            return "/" + theName;
        }
        return theName;
    }

    public void printControllerMap() {
        ArrayList<String> strs = new ArrayList<String>();
        System.out.println("============================================");
        for (Map.Entry<String, ControllerInterface<?>> entry : this._myControllerMap.entrySet()) {
            String key = entry.getKey();
            ControllerInterface<?> value = entry.getValue();
            strs.add(key + " = " + value);
        }
        Collections.sort(strs);
        for (String s : strs) {
            System.out.println(s);
        }
        System.out.println("============================================");
    }

    protected ControlP5 remove(ControlWindow theWindow) {
        theWindow.remove();
        this.controlWindowList.remove(theWindow);
        return this;
    }

    protected void remove(ControllerInterface<?> theController) {
        this._myControllerMap.remove(theController.getAddress());
    }

    public void remove(String theName) {
        String address = this.checkAddress(theName);
        if (this.getController(address) != null) {
            this.getController(address).remove();
        }
        if (this.getGroup(address) != null) {
            this.getGroup(address).remove();
        }
        for (int j = 0; j < this.controlWindowList.size(); ++j) {
            for (int i = 0; i < this.controlWindowList.get(j).getTabs().size(); ++i) {
                if (!((Tab)this.controlWindowList.get(j).getTabs().get(i)).getAddress().equals(address)) continue;
                ((Tab)this.controlWindowList.get(j).getTabs().get(i)).remove();
            }
        }
        this._myControllerMap.remove(address);
    }

    public ControllerInterface<?> get(String theName) {
        String address = this.checkAddress(theName);
        if (this._myControllerMap.containsKey(address)) {
            return this._myControllerMap.get(address);
        }
        return null;
    }

    public <C> C get(Class<C> theClass, String theName) {
        for (ControllerInterface<?> ci : this._myControllerMap.values()) {
            if (ci.getClass() != theClass && ci.getClass().getSuperclass() != theClass) continue;
            return (C)this.get(theName);
        }
        return null;
    }

    @Invisible
    public List<ControllerInterface<?>> getList() {
        LinkedList l = new LinkedList();
        for (ControlWindow c : this.controlWindowList) {
            l.addAll(c.getTabs().get());
        }
        l.addAll(this.getAll());
        return l;
    }

    public Controller<?> getController(String theName) {
        String address = this.checkAddress(theName);
        if (this._myControllerMap.containsKey(address) && this._myControllerMap.get(address) instanceof Controller) {
            return (Controller)this._myControllerMap.get(address);
        }
        return null;
    }

    public ControllerGroup<?> getGroup(String theGroupName) {
        String address = this.checkAddress(theGroupName);
        if (this._myControllerMap.containsKey(address) && this._myControllerMap.get(address) instanceof ControllerGroup) {
            return (ControllerGroup)this._myControllerMap.get(address);
        }
        return null;
    }

    private boolean checkName(String theName) {
        if (this._myControllerMap.containsKey(this.checkAddress(theName))) {
            ControlP5.logger().warning("Controller with name \"" + theName + "\" already exists. overwriting reference of existing controller.");
            return true;
        }
        return false;
    }

    public void moveControllersForObject(Object theObject, ControllerGroup<?> theGroup) {
        if (this._myObjectToControllerMap.containsKey(theObject)) {
            ArrayList cs = (ArrayList)this._myObjectToControllerMap.get(theObject);
            for (ControllerInterface c : cs) {
                ((Controller)c).moveTo(theGroup);
            }
        }
    }

    public void move(Object theObject, ControllerGroup<?> theGroup) {
        this.moveControllersForObject(theObject, theGroup);
    }

    protected void clear() {
        int i;
        for (i = this.controlWindowList.size() - 1; i >= 0; --i) {
            this.controlWindowList.get(i).clear();
        }
        for (i = this.controlWindowList.size() - 1; i >= 0; --i) {
            this.controlWindowList.remove(i);
        }
        this._myControllerMap.clear();
    }

    @Invisible
    public void pre() {
        Iterator itr = this._myFieldChangedListenerMap.values().iterator();
        while (itr.hasNext()) {
            ((FieldChangedListener)itr.next()).update();
        }
    }

    @Invisible
    public void draw() {
        if (!this.blockDraw) {
            this.controlWindow.draw();
        }
    }

    public ControlWindow getWindow() {
        return this.getWindow(this.papplet);
    }

    public ControlP5 disableMouseWheel() {
        this.getWindow().disableMouseWheel();
        return this;
    }

    public ControlP5 enableMouseWheel() {
        this.getWindow().enableMouseWheel();
        return this;
    }

    public boolean isMouseWheel() {
        return this.getWindow().isMouseWheel();
    }

    public ControlWindow.Pointer getPointer() {
        return this.getWindow(this.papplet).getPointer();
    }

    public boolean isMouseOver() {
        return this.getWindow(this.papplet).isMouseOver();
    }

    public boolean isMouseOver(ControllerInterface<?> theController) {
        return this.getWindow(this.papplet).isMouseOver(theController);
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.getWindow(this.papplet).getMouseOverList();
    }

    public ControlWindow getWindow(PApplet theApplet) {
        if (theApplet.equals(this.papplet)) {
            return this.controlWindow;
        }
        return this.controlWindow;
    }

    public ControlWindow getWindow(String theWindowName) {
        for (int i = 0; i < this.controlWindowList.size(); ++i) {
            if (!this.controlWindowList.get(i).name().equals(theWindowName)) continue;
            return this.controlWindowList.get(i);
        }
        ControlP5.logger().warning("ControlWindow " + theWindowName + " does not exist. returning null.");
        return null;
    }

    public ControlP5 addCanvas(ControlWindowCanvas theCanvas) {
        this.getWindow().addCanvas(theCanvas);
        return this;
    }

    public ControlP5 setColor(CColor theColor) {
        this.setColorBackground(theColor.getBackground());
        this.setColorForeground(theColor.getForeground());
        this.setColorActive(theColor.getActive());
        this.setColorCaptionLabel(theColor.getCaptionLabel());
        this.setColorValueLabel(theColor.getValueLabel());
        return this;
    }

    public static CColor getColor() {
        return color;
    }

    public ControlP5 setColorActive(int theColor) {
        color.setActive(theColor);
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.setColorActive(theColor);
        }
        return this;
    }

    public ControlP5 setColorForeground(int theColor) {
        color.setForeground(theColor);
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.setColorForeground(theColor);
        }
        return this;
    }

    public ControlP5 setColorBackground(int theColor) {
        color.setBackground(theColor);
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.setColorBackground(theColor);
        }
        return this;
    }

    public ControlP5 setColorCaptionLabel(int theColor) {
        color.setCaptionLabel(theColor);
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.setColorLabel(theColor);
        }
        return this;
    }

    public ControlP5 setColorValueLabel(int theColor) {
        color.setValueLabel(theColor);
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.setColorValue(theColor);
        }
        return this;
    }

    protected Vector<ControlWindow> getControlWindows() {
        return this.controlWindowList;
    }

    public ControlP5 setMoveable(boolean theFlag) {
        this.isMoveable = theFlag;
        return this;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public boolean saveProperties() {
        return this._myProperties.save();
    }

    public boolean saveProperties(String theFilePath) {
        return this._myProperties.saveAs(theFilePath);
    }

    public boolean saveProperties(String theFilePath, String ... theSets) {
        return this._myProperties.saveAs(theFilePath, theSets);
    }

    public boolean loadProperties() {
        return this._myProperties.load();
    }

    public boolean loadProperties(String theFilePath) {
        File f = new File(theFilePath = this.checkPropertiesPath(theFilePath));
        if (f.exists()) {
            return this._myProperties.load(theFilePath);
        }
        f = new File(theFilePath = this.checkPropertiesPath(theFilePath + ".ser"));
        if (f.exists()) {
            return this._myProperties.load(theFilePath);
        }
        logger.info("Properties File " + theFilePath + " does not exist.");
        return false;
    }

    String checkPropertiesPath(String theFilePath) {
        theFilePath = theFilePath.startsWith("/") || theFilePath.startsWith(".") ? theFilePath : this.papplet.sketchPath(theFilePath);
        return theFilePath;
    }

    @Invisible
    public boolean loadLayout(String theFilePath) {
        File f = new File(theFilePath = this.checkPropertiesPath(theFilePath));
        if (f.exists()) {
            this.getLayout().load(theFilePath);
            return true;
        }
        logger.info("Layout File " + theFilePath + " does not exist.");
        return false;
    }

    public void saveLayout(String theFilePath) {
        this.getLayout().save(theFilePath);
    }

    public String version() {
        return VERSION;
    }

    public void show() {
        this.controlWindow.show();
    }

    public boolean isVisible() {
        return this.controlWindow.isVisible();
    }

    public void hide() {
        this.controlWindow.hide();
    }

    public void update() {
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.update();
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean theFlag) {
        this.isUpdate = theFlag;
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.setUpdate(theFlag);
        }
    }

    public boolean setFont(int theBitFontIndex) {
        if (!BitFontRenderer.fonts.containsKey(theBitFontIndex)) {
            return false;
        }
        bitFont = theBitFontIndex;
        this.controlFont = new ControlFont(bitFont);
        this.updateFont(this.controlFont);
        return true;
    }

    public boolean setFont(ControlFont theControlFont) {
        this.controlFont = theControlFont;
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont thePFont, int theFontSize) {
        this.controlFont = new ControlFont(thePFont, theFontSize);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont thePFont) {
        this.controlFont = new ControlFont(thePFont);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    protected void updateFont(ControlFont theControlFont) {
        Enumeration<ControlWindow> e = this.controlWindowList.elements();
        while (e.hasMoreElements()) {
            ControlWindow myControlWindow = e.nextElement();
            myControlWindow.updateFont(theControlFont);
        }
    }

    public ControlFont getFont() {
        return this.controlFont;
    }

    public void disableShortcuts() {
        this.isShortcuts = false;
    }

    public boolean isShortcuts() {
        return this.isShortcuts;
    }

    public void enableShortcuts() {
        this.isShortcuts = true;
    }

    public Tooltip getTooltip() {
        return this._myTooltip;
    }

    public void setTooltip(Tooltip theTooltip) {
        this._myTooltip = theTooltip;
    }

    public ControllerGroup<?> begin() {
        return this.begin(this.controlWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControllerGroup<?> theGroup) {
        this.setCurrentPointer(theGroup);
        return theGroup;
    }

    public ControllerGroup<?> begin(int theX, int theY) {
        return this.begin(this.controlWindow.getTab("default"), theX, theY);
    }

    public ControllerGroup<?> begin(ControllerGroup<?> theGroup, int theX, int theY) {
        this.setCurrentPointer(theGroup);
        theGroup.autoPosition.x = theX;
        theGroup.autoPosition.y = theY;
        theGroup.autoPositionOffsetX = theX;
        return theGroup;
    }

    public ControllerGroup<?> begin(ControlWindow theWindow) {
        return this.begin(theWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControlWindow theWindow, int theX, int theY) {
        return this.begin(theWindow.getTab("default"), theX, theY);
    }

    public ControllerGroup<?> end(ControllerGroup<?> theGroup) {
        this.releaseCurrentPointer(theGroup);
        return theGroup;
    }

    public ControllerGroup<?> end() {
        return this.end(this.controlWindow.getTab("default"));
    }

    public void addPositionTo(int theX, int theY, List<ControllerInterface<?>> theControllers) {
        PVector v = new PVector((float)theX, (float)theY);
        for (ControllerInterface<?> c : theControllers) {
            c.setPosition(PVector.add((PVector)c.getPosition(), (PVector)v));
        }
    }

    public void addPositionTo(int theX, int theY, ControllerInterface<?> ... theControllers) {
        this.addPositionTo(theX, theY, Arrays.asList(theControllers));
    }

    public void dispose() {
        if (!isApplet) {
            this.clear();
        }
    }

    public static Logger logger() {
        return logger;
    }

    @Deprecated
    public boolean setControlFont(ControlFont theControlFont) {
        return this.setFont(theControlFont);
    }

    @Deprecated
    public boolean setControlFont(PFont thePFont, int theFontSize) {
        return this.setFont(thePFont, theFontSize);
    }

    @Deprecated
    public boolean setControlFont(PFont thePFont) {
        return this.setFont(thePFont);
    }

    @Deprecated
    public ControlFont getControlFont() {
        return this.getFont();
    }

    @Deprecated
    public boolean save(String theFilePath) {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public boolean save() {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public boolean load(String theFileName) {
        ControlP5.logger().info("Loading ControlP5 from an XML file has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public void trigger() {
        for (String key : this._myControllerMap.keySet()) {
            if (!(this._myControllerMap.get(key) instanceof Controller)) continue;
            ((Controller)this._myControllerMap.get(key)).trigger();
        }
    }

    @Deprecated
    public void disableKeys() {
        this.isShortcuts = false;
    }

    @Deprecated
    public void enableKeys() {
        this.isShortcuts = true;
    }

    @Deprecated
    public void lock() {
        this.isMoveable = false;
    }

    @Deprecated
    public void unlock() {
        this.isMoveable = true;
    }

    @Deprecated
    protected Vector<ControlWindow> controlWindows() {
        return this.getControlWindows();
    }

    @Deprecated
    public Controller<?> controller(String theName) {
        return this.getController(theName);
    }

    @Deprecated
    public ControllerGroup<?> group(String theGroupName) {
        return this.getGroup(theGroupName);
    }

    @Deprecated
    public ControlWindow window(String theWindowName) {
        return this.getWindow(theWindowName);
    }

    @Deprecated
    public ControlWindow window() {
        return this.getWindow();
    }

    @Deprecated
    public Tab tab(ControlWindow theWindow, String theName) {
        return this.getTab(theWindow, theName);
    }

    @Deprecated
    public ControlWindow window(PApplet theApplet) {
        return this.getWindow(theApplet);
    }

    @Deprecated
    public ControlBroadcaster controlbroadcaster() {
        return this._myControlBroadcaster;
    }

    @Deprecated
    public Tab tab(String theName) {
        return this.getTab(theName);
    }

    @Deprecated
    public ControllerInterface<?>[] getControllerList() {
        ControllerInterface[] myControllerList = new ControllerInterface[this._myControllerMap.size()];
        this._myControllerMap.values().toArray(myControllerList);
        return myControllerList;
    }

    @Deprecated
    public ControlP5 setColorLabel(int theColor) {
        return this.setColorCaptionLabel(theColor);
    }

    @Deprecated
    public ControlP5 setColorValue(int theColor) {
        return this.setColorValueLabel(theColor);
    }

    static {
        logger = Logger.getLogger(ControlP5.class.getName());
        bitFont = 0;
        welcome = 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Layout {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Invisible {
    }
}

