/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.ControlBehavior;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlP5IOHandler;
import controlP5.ControlWindow;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerPlug;
import controlP5.ControllerProperty;
import controlP5.ControllerSprite;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.Pointer;
import controlP5.Tab;
import controlP5.Textfield;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller<T>
implements ControllerInterface<T>,
CDrawable,
ControlP5Constants {
    protected PVector position = new PVector();
    protected PVector positionBuffer = new PVector();
    protected PVector absolutePosition = new PVector();
    protected ControllerInterface<?> _myParent;
    protected final String _myName;
    protected ControlWindow _myControlWindow;
    protected boolean isMousePressed = false;
    protected ControlP5 cp5;
    protected int width;
    protected int height;
    protected int _myId = -1;
    protected float _myValue = Float.NaN;
    protected float _myDefaultValue = Float.NaN;
    protected String _myStringValue = "";
    protected float[] _myArrayValue;
    protected Label _myCaptionLabel;
    protected Label _myValueLabel;
    protected boolean isLabelVisible = true;
    protected boolean isMoveable = true;
    protected boolean isBroadcast = true;
    protected boolean isVisible = true;
    protected boolean isActive = false;
    protected boolean isLock = false;
    protected boolean isUserInteraction = true;
    protected boolean isInit = false;
    protected List<ControlListener> _myControlListener;
    protected CColor color = new CColor();
    protected float _myMin;
    protected float _myMax;
    protected float _myUnit;
    protected String target;
    protected Object targetObject;
    protected ControlBehavior _myBehavior;
    protected boolean isBehavior;
    protected List<Controller<?>> subelements;
    protected int _myBroadcastType = 2;
    protected boolean isUpdate = false;
    protected int _myDecimalPoints = 2;
    protected boolean isSprite;
    public static int autoWidth = 49;
    public static int autoHeight = 19;
    public static PVector autoSpacing = new PVector(10.0f, 10.0f, 0.0f);
    protected boolean[] availableImages = new boolean[4];
    protected PImage[] images = new PImage[4];
    protected ControllerView<T> _myControllerView;
    protected ControllerView<T> _myDebugView;
    protected int _myDisplayMode = 0;
    protected int _myPickingColor = -256;
    protected boolean mouseover;
    protected String _myAddress = "";
    protected List<ControllerPlug> _myControllerPlugList;
    protected boolean tooltipEnabled;
    protected boolean listening;
    protected boolean isInside = false;
    private T me;
    protected boolean dragged;
    protected ControllerSprite sprite;

    public Controller(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 0.0f, autoWidth, autoHeight);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    protected Controller(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, float theX, float theY, int theWidth, int theHeight) {
        this.cp5 = theControlP5;
        this.me = this;
        if (this.cp5 == null) {
            this.isBroadcast = false;
        }
        this._myName = theName;
        this.position = new PVector(theX, theY, 0.0f);
        this.positionBuffer = new PVector(theX, theY, 0.0f);
        this.setParent(theParent);
        if (theParent != null) {
            this.color.set(theParent.color);
        } else {
            this.color.set(ControlP5.color);
        }
        this.width = theWidth;
        this.height = theHeight;
        this._myCaptionLabel = new Label(this.cp5, theName);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        this._myValueLabel = new Label(this.cp5, "valueLabel");
        this._myControllerPlugList = new Vector<ControllerPlug>();
        this._myControlListener = new Vector<ControlListener>();
        this.subelements = new Vector();
        this._myArrayValue = new float[0];
        this._myDebugView = new DebugView();
        this.setView(this._myDebugView);
    }

    @Override
    @ControlP5.Layout
    public String getAddress() {
        return this._myAddress;
    }

    @Override
    @ControlP5.Invisible
    @ControlP5.Layout
    public T setAddress(String theAddress) {
        if (this._myAddress.length() == 0) {
            this._myAddress = theAddress;
        }
        return this.me;
    }

    protected Controller(ControlP5 theControlP5, String theName, float theX, float theY, int theWidth, int theHeight) {
        this(theControlP5, theControlP5.getTab("default"), theName, theX, theY, theWidth, theHeight);
    }

    protected Controller(String theName, int theX, int theY) {
        this._myName = theName;
        this.position = new PVector((float)theX, (float)theY, 0.0f);
    }

    @Override
    @ControlP5.Invisible
    public void init() {
        this._myDefaultValue = this._myValue;
        this.cp5.getControlBroadcaster().plug((Object)this.cp5.papplet, this, this._myName);
        this.initControllerValue();
        this.isInit = this.cp5.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
        this.updateDisplayMode(0);
    }

    protected final void initControllerValue() {
        if (this._myValue == this.getMin() || Float.isNaN(this._myValue)) {
            if (this._myControllerPlugList.size() == 1) {
                if (this.getControllerPlugList().get(0).getValue() == null) {
                    this.setDefaultValue(this.getMin());
                } else {
                    float myInitValue = 0.0f;
                    if (this.getControllerPlugList().get(0).getValue() instanceof Boolean) {
                        boolean myBoolean = new Boolean(this.getControllerPlugList().get(0).getValue().toString());
                        myInitValue = myBoolean ? 1.0f : 0.0f;
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Float) {
                        myInitValue = new Float(this.getControllerPlugList().get(0).getValue().toString()).floatValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Integer) {
                        myInitValue = new Integer(this.getControllerPlugList().get(0).getValue().toString()).intValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof String) {
                        this._myStringValue = this.getControllerPlugList().get(0).getValue().toString();
                    }
                    this.setDefaultValue(myInitValue);
                }
            } else if (Float.isNaN(this.getDefaultValue())) {
                this.setDefaultValue(this.getMin());
            }
        }
        this._myValue = this._myDefaultValue;
    }

    protected void updateFont(ControlFont theControlFont) {
        this._myCaptionLabel.updateFont(theControlFont);
        this._myValueLabel.updateFont(theControlFont);
    }

    public T setBehavior(ControlBehavior theBehavior) {
        this.isBehavior = true;
        this._myBehavior = theBehavior;
        this._myBehavior.init(this);
        return this.me;
    }

    public T removeBehavior() {
        this.isBehavior = false;
        this._myBehavior = null;
        return this.me;
    }

    public ControlBehavior getBehavior() {
        return this._myBehavior;
    }

    @ControlP5.Layout
    public float getDefaultValue() {
        return this._myDefaultValue;
    }

    @ControlP5.Layout
    public T setDefaultValue(float theValue) {
        this._myDefaultValue = theValue;
        return this.me;
    }

    @ControlP5.Layout
    public T setMoveable(boolean theValue) {
        this.isMoveable = theValue;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isMoveable() {
        return this.isMoveable;
    }

    @ControlP5.Layout
    public T setLabelVisible(boolean theValue) {
        this.isLabelVisible = theValue;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isLabelVisible() {
        return this.isLabelVisible;
    }

    @ControlP5.Layout
    public T setBroadcast(boolean theFlag) {
        this.isBroadcast = theFlag;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @Override
    @ControlP5.Layout
    public PVector getPosition() {
        return this.position;
    }

    @Override
    @ControlP5.Layout
    public T setPosition(PVector thePVector) {
        this.position.x = thePVector.x;
        this.position.y = thePVector.y;
        this.position.z = thePVector.z;
        this.positionBuffer.x = thePVector.x;
        this.positionBuffer.y = thePVector.y;
        this.positionBuffer.z = thePVector.z;
        return this.me;
    }

    @Override
    public T setPosition(float theX, float theY) {
        this.position.x = theX;
        this.position.y = theY;
        this.positionBuffer.x = this.position.x;
        this.positionBuffer.y = this.position.y;
        return this.me;
    }

    @Override
    public PVector getAbsolutePosition() {
        return this.absolutePosition;
    }

    @Override
    @ControlP5.Invisible
    public T setAbsolutePosition(PVector thePVector) {
        this.absolutePosition.x = thePVector.x;
        this.absolutePosition.y = thePVector.y;
        this.absolutePosition.z = thePVector.z;
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateAbsolutePosition() {
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public final void continuousUpdateEvents() {
        if (this.isBehavior && this._myBehavior.isActive() && !this.isMousePressed) {
            this._myBehavior.update();
        }
    }

    @Override
    @ControlP5.Invisible
    public final T updateEvents() {
        if (this.isInside) {
            boolean moved;
            boolean bl = moved = this._myControlWindow.mouseX - this._myControlWindow.pmouseX != 0 || this._myControlWindow.mouseY - this._myControlWindow.pmouseY != 0;
            if (this.isMousePressed) {
                if (moved) {
                    this.onDrag();
                    this.dragged = true;
                }
            } else if (moved) {
                this.onMove();
            }
        }
        if (this.isVisible && this.isMousePressed == this._myControlWindow.mouselock) {
            if (this.isMousePressed && this.cp5.keyHandler.isAltDown() && this.isMoveable) {
                if (!this.cp5.isMoveable) {
                    this.positionBuffer.x += (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
                    this.positionBuffer.y += (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
                    if (this.cp5.keyHandler.isShiftDown) {
                        this.position.x = (int)this.positionBuffer.x / 10 * 10;
                        this.position.y = (int)this.positionBuffer.y / 10 * 10;
                    } else {
                        this.position.set(this.positionBuffer);
                    }
                }
            } else if (!this.isLock) {
                if (this.isInside) {
                    this.setMouseOver(true);
                }
                if (this.inside()) {
                    if (!this.isInside) {
                        this.onEnter();
                        this.setIsInside(true);
                    }
                } else {
                    if (this.isInside && !this.isMousePressed) {
                        this.onLeave();
                        this.setMouseOver(false);
                        this.setIsInside(false);
                    }
                    if (!this.isInside && this.mouseover) {
                        this.setMouseOver(false);
                    }
                }
            }
        }
        return this.me;
    }

    public final Pointer getPointer() {
        return new Pointer(){

            public int x() {
                return (int)((float)Controller.this._myControlWindow.mouseX - Controller.this._myParent.getAbsolutePosition().x - Controller.this.position.x);
            }

            public int y() {
                return (int)((float)Controller.this._myControlWindow.mouseY - Controller.this._myParent.getAbsolutePosition().y - Controller.this.position.y);
            }

            public int px() {
                return (int)((float)Controller.this._myControlWindow.pmouseX - Controller.this._myParent.getAbsolutePosition().x - Controller.this.position.x);
            }

            public int py() {
                return (int)((float)Controller.this._myControlWindow.pmouseY - Controller.this._myParent.getAbsolutePosition().y - Controller.this.position.y);
            }
        };
    }

    @Override
    @ControlP5.Invisible
    public final boolean setMousePressed(boolean theStatus) {
        if (!this.isVisible && !this.isUserInteraction) {
            return false;
        }
        if (theStatus) {
            if (this.isInside) {
                this.isMousePressed = true;
                if (!this.cp5.keyHandler.isAltDown()) {
                    this.mousePressed();
                    this.onPress();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 1));
                }
                return true;
            }
        } else {
            if (this.isMousePressed && this.inside()) {
                this.isMousePressed = false;
                if (!this.cp5.keyHandler.isAltDown()) {
                    if (!this.dragged) {
                        this.onClick();
                    }
                    this.mouseReleased();
                    this.onRelease();
                    this.dragged = false;
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 8));
                }
            }
            if (!this.inside()) {
                this.setIsInside(false);
                if (this.isMousePressed) {
                    this.isMousePressed = false;
                    this.mouseReleasedOutside();
                    this.onReleaseOutside();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 16));
                }
                if (this instanceof Textfield) {
                    this.mouseReleasedOutside();
                    this.onReleaseOutside();
                }
            }
        }
        return false;
    }

    public T listen(boolean theValue) {
        if (theValue == this.listening) {
            return this.me;
        }
        this.listening = theValue;
        if (this.listening) {
            this.cp5.listenTo(this._myName, this.cp5.getObjectForController(this));
        } else {
            this.cp5.stopListeningTo(this._myName, this.cp5.getObjectForController(this));
        }
        return this.me;
    }

    public boolean isListening() {
        return this.listening;
    }

    @Override
    public boolean isMouseOver() {
        return this.mouseover;
    }

    @Override
    public T setMouseOver(boolean theFlag) {
        if (this.mouseover == theFlag) {
            return this.me;
        }
        this.mouseover = theFlag;
        if (this.mouseover) {
            this._myControlWindow.setMouseOverController(this);
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 2));
            this.cp5.getTooltip().activate(this);
        } else {
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 4));
            this._myControlWindow.removeMouseOverFor(this);
            this.cp5.getTooltip().deactivate();
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateInternalEvents(PApplet theApplet) {
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public void draw(PApplet theApplet) {
        theApplet.pushMatrix();
        theApplet.translate(this.position.x, this.position.y);
        this._myControllerView.display(theApplet, this.me);
        theApplet.popMatrix();
        theApplet.pushMatrix();
        theApplet.popMatrix();
    }

    @Override
    @ControlP5.Invisible
    public T add(ControllerInterface<?> theElement) {
        ControlP5.logger().warning(" add() not supported.");
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T remove(ControllerInterface<?> theElement) {
        ControlP5.logger().warning("remove() not supported.");
        return this.me;
    }

    @Override
    public void remove() {
        this._myControlWindow.removeMouseOverFor(this);
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.cp5.remove(this);
        }
    }

    @Override
    public T bringToFront() {
        return this.bringToFront(this);
    }

    @Override
    public T bringToFront(ControllerInterface<?> theController) {
        if (this._myParent instanceof Tab) {
            this.moveTo((Tab)this._myParent);
        } else {
            this._myParent.bringToFront(theController);
        }
        if (theController != this && this.subelements.contains(theController) && theController instanceof Controller) {
            this.subelements.remove(theController);
            this.subelements.add((Controller)theController);
        }
        return this.me;
    }

    @Override
    public String getName() {
        return this._myName;
    }

    public final T moveTo(String theTabName) {
        this.setTab(theTabName);
        for (Controller<?> c : this.subelements) {
            c.moveTo(theTabName);
        }
        return this.me;
    }

    public final T moveTo(Tab theTab) {
        this.setTab(theTab.getWindow(), theTab.getName());
        for (Controller<?> c : this.subelements) {
            c.moveTo(theTab);
        }
        return this.me;
    }

    public final T moveTo(PApplet theApplet) {
        this.setTab("default");
        for (Controller<?> c : this.subelements) {
            c.moveTo(theApplet);
        }
        return this.me;
    }

    public final T moveTo(PApplet theApplet, String theTabName) {
        this.setTab(theTabName);
        for (Controller<?> c : this.subelements) {
            c.moveTo(theApplet, theTabName);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow theControlWindow) {
        this.setTab(theControlWindow, "default");
        for (Controller<?> c : this.subelements) {
            c.moveTo(theControlWindow);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow theControlWindow, String theTabName) {
        this.setTab(theControlWindow, theTabName);
        for (Controller<?> c : this.subelements) {
            c.moveTo(theControlWindow, theTabName);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup, Tab theTab, ControlWindow theControlWindow) {
        for (Controller<?> c : this.subelements) {
            c.moveTo(theGroup, theTab, theControlWindow);
        }
        if (theGroup != null) {
            this.setGroup(theGroup);
            return this.me;
        }
        if (theControlWindow == null) {
            theControlWindow = this.cp5.controlWindow;
        }
        this.setTab(theControlWindow, theTab.getName());
        return this.me;
    }

    @Override
    public final T moveTo(ControlGroup<?> theGroup) {
        if (theGroup != null) {
            this.setGroup(theGroup);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup) {
        if (theGroup != null) {
            this.setGroup(theGroup);
        }
        return this.me;
    }

    public final T setTab(String theName) {
        this.setParent(this.cp5.getTab(theName));
        for (Controller<?> c : this.subelements) {
            c.setTab(theName);
        }
        return this.me;
    }

    public final T setTab(ControlWindow theWindow, String theName) {
        this.setParent(this.cp5.getTab(theWindow, theName));
        for (Controller<?> c : this.subelements) {
            c.setTab(theWindow, theName);
        }
        return this.me;
    }

    public final T setGroup(String theName) {
        this.setParent(this.cp5.getGroup(theName));
        for (Controller<?> c : this.subelements) {
            c.setGroup(theName);
        }
        return this.me;
    }

    public final T setGroup(ControllerGroup<?> theGroup) {
        this.setParent(theGroup);
        for (Controller<?> c : this.subelements) {
            c.setGroup(theGroup);
        }
        return this.me;
    }

    @Override
    public Tab getTab() {
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    @ControlP5.Invisible
    public final T setParent(ControllerInterface<?> theParent) {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        this.absolutePosition = new PVector(this.position.x, this.position.y);
        if (theParent != null) {
            this._myParent = theParent;
            this._myParent.add(this);
            this.absolutePosition.add(this._myParent.getPosition());
            this._myControlWindow = this._myParent.getWindow();
        }
        this.setMouseOver(false);
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    @ControlP5.Layout
    public ControllerInterface<?> getParent() {
        return this._myParent;
    }

    @Override
    public ControlWindow getWindow() {
        return this._myControlWindow;
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x + this._myParent.getAbsolutePosition().x && (float)this._myControlWindow.mouseX < this.position.x + this._myParent.getAbsolutePosition().x + (float)this.width && (float)this._myControlWindow.mouseY > this.position.y + this._myParent.getAbsolutePosition().y && (float)this._myControlWindow.mouseY < this.position.y + this._myParent.getAbsolutePosition().y + (float)this.height;
    }

    public boolean isInside() {
        return this.isInside;
    }

    @ControlP5.Layout
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMousePressed() {
        return this.isMousePressed;
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    protected void onDrag() {
    }

    protected void onMove() {
    }

    protected void onClick() {
    }

    protected void onPress() {
    }

    protected void onRelease() {
    }

    protected void onScroll(int theAmount) {
    }

    protected void onReleaseOutside() {
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void mouseReleasedOutside() {
    }

    protected void setIsInside(boolean theFlag) {
        this.isInside = theFlag;
    }

    protected boolean getIsInside() {
        return this.isInside;
    }

    @Override
    @ControlP5.Invisible
    public void keyEvent(KeyEvent theEvent) {
    }

    @Override
    @ControlP5.Layout
    public T setId(int theId) {
        this._myId = theId;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public int getId() {
        return this._myId;
    }

    protected ControllerPlug getControllerPlug(int theIndex) {
        return this._myControllerPlugList.get(theIndex);
    }

    public List<ControllerPlug> getControllerPlugList() {
        return this._myControllerPlugList;
    }

    protected boolean checkControllerPlug(ControllerPlug thePlug) {
        for (ControllerPlug cp : this._myControllerPlugList) {
            if (!cp.getObject().equals(thePlug.getObject()) || !cp.getName().equals(thePlug.getName())) continue;
            return true;
        }
        return false;
    }

    protected void addControllerPlug(ControllerPlug thePlug) {
        if (this.checkControllerPlug(thePlug)) {
            return;
        }
        this._myControllerPlugList.add(thePlug);
    }

    protected void removeControllerPlug(ControllerPlug thePlug) {
        this._myControllerPlugList.remove(thePlug);
    }

    public T plugTo(Object[] theObjects) {
        for (Object o : theObjects) {
            this.plugTo(o, this._myName);
        }
        return this.me;
    }

    public T plugTo(Object[] theObjects, String theName) {
        for (Object o : theObjects) {
            this.plugTo(o, theName);
        }
        return this.me;
    }

    public T plugTo(Object theObject) {
        return this.plugTo(theObject, this._myName);
    }

    public T plugTo(Object theObject, String theName) {
        if (theObject instanceof PApplet) {
            this.unplugFrom(theObject);
        }
        this.cp5.getControlBroadcaster().plug(theObject, this, theName);
        this.cp5.getControlBroadcaster().plug(theObject, this, this.cp5.getControlBroadcaster().getEventMethod());
        return this.me;
    }

    public T unplugFrom(Object[] theObjects) {
        for (Object o : theObjects) {
            this.unplugFrom(o);
        }
        return this.me;
    }

    public T unplugFrom(Object theObject) {
        Iterator<ControllerPlug> i = this._myControllerPlugList.iterator();
        while (i.hasNext()) {
            if (!i.next().getObject().equals(theObject)) continue;
            i.remove();
        }
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public float getValue() {
        return this._myValue;
    }

    @Override
    @ControlP5.Layout
    public T setStringValue(String theValue) {
        this._myStringValue = theValue;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    @ControlP5.Layout
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    public float getArrayValue(int theIndex) {
        if (theIndex >= 0 && theIndex < this._myArrayValue.length) {
            return this._myArrayValue[theIndex];
        }
        return Float.NaN;
    }

    @ControlP5.Layout
    public T setArrayValue(float[] theArray) {
        this._myArrayValue = theArray;
        return this.me;
    }

    public T setArrayValue(int theIndex, float theValue) {
        if (theIndex >= 0 && theIndex < this._myArrayValue.length) {
            this._myArrayValue[theIndex] = theValue;
        }
        return this.me;
    }

    public final T changeValue(float theValue) {
        boolean br = this.isBroadcast;
        this.isBroadcast = false;
        this.setValue(theValue);
        this.isBroadcast = br;
        return this.me;
    }

    @Override
    public T update() {
        return this.me;
    }

    @Override
    public T setUpdate(boolean theFlag) {
        this.isUpdate = theFlag;
        return this.me;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    @ControlP5.Invisible
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    @ControlP5.Layout
    public CColor getColor() {
        return this.color;
    }

    @ControlP5.Layout
    public T setCaptionLabel(String theLabel) {
        this._myCaptionLabel.set(theLabel);
        return this.me;
    }

    @ControlP5.Layout
    public T setValueLabel(String theLabel) {
        this._myValueLabel.set(theLabel);
        return this.me;
    }

    @ControlP5.Invisible
    public String getLabel() {
        return this._myCaptionLabel.getText();
    }

    public T addListener(ControlListener theListener) {
        this._myControlListener.add(theListener);
        return this.me;
    }

    public T removeListener(ControlListener theListener) {
        this._myControlListener.remove(theListener);
        return this.me;
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    public T addCallback(CallbackListener theListener) {
        this.cp5.addCallback(theListener, this);
        return this.me;
    }

    public T removeCallback(CallbackListener theListener) {
        this.cp5.removeCallback(theListener);
        return this.me;
    }

    public T removeCallback() {
        this.cp5.removeCallback((Controller<?>)this);
        return this.me;
    }

    protected void broadcast() {
        this.broadcast(this._myBroadcastType);
    }

    protected void broadcast(int theType) {
        theType = this._myBroadcastType;
        ControlEvent myEvent = new ControlEvent(this);
        for (ControlListener cl : this._myControlListener) {
            cl.controlEvent(myEvent);
        }
        if (this.isBroadcast && this.isInit) {
            this.cp5.getControlBroadcaster().broadcast(myEvent, theType);
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 32));
        }
        this.isInit = true;
    }

    @Override
    @ControlP5.Layout
    public boolean isVisible() {
        if (this.getParent() != null && !this.getParent().isVisible()) {
            return false;
        }
        return this.isVisible;
    }

    @ControlP5.Layout
    public T setVisible(boolean theFlag) {
        this.isVisible = theFlag;
        if (!theFlag) {
            this.isActive = false;
        }
        return this.me;
    }

    @Override
    public T hide() {
        this.setMouseOver(false);
        this.isVisible = false;
        this.isActive = false;
        return this.me;
    }

    @Override
    public T show() {
        this.isVisible = true;
        return this.me;
    }

    @Override
    public T setColor(CColor theColor) {
        this.color.set(theColor);
        this.setColorCaptionLabel(theColor.getCaptionLabel());
        this.setColorValueLabel(theColor.getValueLabel());
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorActive(int theColor) {
        this.color.setActive(theColor);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        return this.me;
    }

    @ControlP5.Layout
    public T setColorCaptionLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        return this.me;
    }

    @ControlP5.Layout
    public T setColorValueLabel(int theColor) {
        this.color.setValueLabel(theColor);
        if (this._myValueLabel != null) {
            this._myValueLabel.setColor(this.color.getValueLabel());
        }
        return this.me;
    }

    public T setImages(PImage theImageDefault, PImage theImageOver, PImage theImageActive) {
        this.setImage(theImageDefault, 0);
        this.setImage(theImageOver, 1);
        this.setImage(theImageActive, 2);
        this.setImage(theImageActive, 3);
        return this.me;
    }

    public T setImages(PImage theImageDefault, PImage theImageOver, PImage theImageActive, PImage theImageHighlight) {
        this.setImage(theImageDefault, 0);
        this.setImage(theImageOver, 1);
        this.setImage(theImageActive, 2);
        this.setImage(theImageHighlight, 3);
        return this.me;
    }

    public T setImages(PImage ... imgs) {
        if (imgs.length < 3 || imgs.length > 4) {
            return this.me;
        }
        this.setImage(imgs[0], 0);
        this.setImage(imgs[1], 1);
        this.setImage(imgs[2], 2);
        this.setImage(imgs.length == 3 ? imgs[2] : imgs[3], 3);
        return this.me;
    }

    public PImage setImage(PImage theImage) {
        return this.setImage(theImage, 0);
    }

    public PImage setImage(PImage theImage, int theState) {
        if (theImage != null) {
            this.images[theState] = theImage;
            this.availableImages[theState] = true;
            this.updateDisplayMode(1);
            return theImage;
        }
        return null;
    }

    public T updateSize() {
        if (this.images[0] != null) {
            this.setSize(this.images[0]);
        }
        return this.me;
    }

    public T setSize(PImage theImage) {
        if (theImage != null) {
            this.setSize(theImage.width, theImage.height);
        }
        return this.me;
    }

    public T setSize(int theWidth, int theHeight) {
        this.setWidth(theWidth);
        this.setHeight(theHeight);
        return this.me;
    }

    protected T updateDisplayMode(int theMode) {
        if (theMode != 0) {
            ControlP5.logger().warning("Image-based or custom displays are not yet implemented for this type of controller. (" + this.getClass().getName() + ")");
        }
        return this.me;
    }

    public T setView(ControllerView<T> theDisplay) {
        this.setView(theDisplay, 3);
        return this.me;
    }

    public void setView(ControllerView<T> theDisplay, int theMode) {
        this._myDisplayMode = theMode;
        this._myControllerView = theDisplay;
    }

    @Deprecated
    public T setDisplay(ControllerDisplay theDisplay) {
        return this.setView(theDisplay);
    }

    @Deprecated
    public void setDisplay(ControllerDisplay theDisplay, int theMode) {
        this.setView(theDisplay, theMode);
    }

    @ControlP5.Layout
    public Label getCaptionLabel() {
        return this._myCaptionLabel;
    }

    @ControlP5.Layout
    public Label getValueLabel() {
        return this._myValueLabel;
    }

    @ControlP5.Layout
    public float getMax() {
        return this._myMax;
    }

    @ControlP5.Layout
    public float getMin() {
        return this._myMin;
    }

    @ControlP5.Layout
    public T setMin(float theValue) {
        this._myMin = theValue;
        this.changeValue(this.getValue());
        return this.me;
    }

    @ControlP5.Layout
    public T setMax(float theValue) {
        this._myMax = theValue;
        this.changeValue(this.getValue());
        return this.me;
    }

    @ControlP5.Layout
    public T setWidth(int theWidth) {
        this.width = theWidth;
        return this.me;
    }

    @ControlP5.Layout
    public T setHeight(int theHeight) {
        this.height = theHeight;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public int getWidth() {
        return this.width;
    }

    @Override
    @ControlP5.Layout
    public int getHeight() {
        return this.height;
    }

    @ControlP5.Layout
    public T setDecimalPrecision(int theValue) {
        this._myDecimalPoints = theValue;
        int[] t = this._myValueLabel.getAlign();
        this._myValueLabel = new Label(this.cp5, "" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)));
        this._myValueLabel.align(t);
        this._myValueLabel.setColor(this.color.getValueLabel());
        this._myValueLabel.set("" + this.adjustValue(this.getValue()));
        return this.me;
    }

    @ControlP5.Layout
    public int getDecimalPrecision() {
        return this._myDecimalPoints;
    }

    protected String adjustValue(float theValue) {
        return this.adjustValue(theValue, this._myDecimalPoints);
    }

    protected String adjustValue(float theValue, int theFloatPrecision) {
        String myLabelValue;
        block6: {
            int myFloatNumberLength;
            block5: {
                int n;
                int myIndex;
                myFloatNumberLength = theFloatPrecision + 1;
                if (this.getControllerPlugList().size() > 0) {
                    for (ControllerPlug cp : this.getControllerPlugList()) {
                        if (cp.getClassType() != Integer.TYPE) continue;
                        myFloatNumberLength = 0;
                    }
                }
                if ((myIndex = (myLabelValue = "" + theValue).indexOf(46)) <= 0) break block5;
                if (theFloatPrecision == 0) {
                    --myIndex;
                }
                if ((n = (myLabelValue = myLabelValue.substring(0, Math.min(myLabelValue.length(), myIndex + myFloatNumberLength))).length() - myIndex) >= myFloatNumberLength) break block6;
                for (int i = 0; i < myFloatNumberLength - n; ++i) {
                    myLabelValue = myLabelValue + "0";
                }
                break block6;
            }
            myLabelValue = myLabelValue + ".";
            for (int i = 0; i < myFloatNumberLength; ++i) {
                myLabelValue = myLabelValue + "0";
            }
        }
        return myLabelValue;
    }

    public T align(int theCaptionX, int theCaptionY, int theValueX, int theValueY) {
        this.getCaptionLabel().align(theCaptionX, theCaptionY);
        this.getCaptionLabel().align(theValueX, theValueY);
        return this.me;
    }

    public ControlWindow getControlWindow() {
        return this._myControlWindow;
    }

    public T lock() {
        this.isLock = true;
        return this.me;
    }

    public T unlock() {
        this.isLock = false;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isLock() {
        return this.isLock;
    }

    @ControlP5.Layout
    public T setLock(boolean theValue) {
        this.isLock = theValue;
        return this.me;
    }

    @ControlP5.Invisible
    public T setUserInteraction(boolean theValue) {
        this.isUserInteraction = theValue;
        return this.me;
    }

    @ControlP5.Invisible
    public boolean isUserInteraction() {
        return this.isUserInteraction;
    }

    public T registerTooltip(String theText) {
        this.cp5.getTooltip().register(this, theText);
        return this.me;
    }

    public T unregisterTooltip() {
        this.cp5.getTooltip().unregister(this);
        return this.me;
    }

    protected T setTooltipEnabled(boolean theValue) {
        this.tooltipEnabled = theValue;
        return this.me;
    }

    protected boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public T linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, autoSpacing);
        return this.me;
    }

    @Override
    public ControllerProperty getProperty(String thePropertyName) {
        return this.cp5.getProperties().getProperty(this, thePropertyName);
    }

    @Override
    public ControllerProperty getProperty(String theSetter, String theGetter) {
        return this.cp5.getProperties().getProperty(this, theSetter, theGetter);
    }

    @Override
    public T registerProperty(String thePropertyName) {
        this.cp5.getProperties().register(this, thePropertyName);
        return this.me;
    }

    @Override
    public T registerProperty(String theSetter, String theGetter) {
        this.cp5.getProperties().register(this, theSetter, theGetter);
        return this.me;
    }

    @Override
    public T removeProperty(String thePropertyName) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, thePropertyName);
        return this.me;
    }

    @Override
    public T removeProperty(String theSetter, String theGetter) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, theSetter, theGetter);
        return this.me;
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getSimpleName() + "]";
    }

    public String getInfo() {
        return "[ type:\tController\nname:\t" + this._myName + "\n" + "label:\t" + this._myCaptionLabel.getText() + "\n" + "id:\t" + this._myId + "\n" + "value:\t" + this.getValue() + "\n" + "arrayvalue:\t" + ControlP5IOHandler.arrayToString(this._myArrayValue) + "\n" + "position:\t" + this.position + "\n" + "absolute:\t" + this.absolutePosition + "\n" + "width:\t" + this.getWidth() + "\n" + "height:\t" + this.getHeight() + "\n" + "color:\t" + this.getColor() + "\n" + "visible:\t" + this.isVisible + "\n" + "moveable:\t" + this.isMoveable + " ]";
    }

    @Deprecated
    public void setSprite(ControllerSprite theSprite) {
        this.sprite = theSprite;
        this.width = this.sprite.width();
        this.height = this.sprite.height();
        this.enableSprite();
    }

    @Deprecated
    public ControllerSprite getSprite() {
        return this.sprite;
    }

    @Deprecated
    public PVector position() {
        return this.getPosition();
    }

    @Deprecated
    public PVector absolutePosition() {
        return this.getAbsolutePosition();
    }

    @Deprecated
    public void setWindow(PApplet theApplet) {
        this.moveTo(theApplet);
    }

    @Deprecated
    public ControlWindow setWindow(ControlWindow theWindow) {
        this.moveTo(theWindow);
        return this._myControlWindow;
    }

    @Deprecated
    public void trigger() {
        this.setValue(this.value());
    }

    @Override
    @Deprecated
    public T setColorLabel(int theColor) {
        this.setColorCaptionLabel(theColor);
        return this.me;
    }

    @Override
    @Deprecated
    public T setColorValue(int theColor) {
        this.setColorValueLabel(theColor);
        return this.me;
    }

    @Deprecated
    public float value() {
        return this.getValue();
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this.getArrayValue();
    }

    @Deprecated
    public float min() {
        return this.getMin();
    }

    @Deprecated
    public float max() {
        return this.getMax();
    }

    @Deprecated
    public CColor color() {
        return this.color;
    }

    @Deprecated
    public ControlBehavior behavior() {
        return this.getBehavior();
    }

    @Deprecated
    public Label captionLabel() {
        return this.getCaptionLabel();
    }

    @Deprecated
    public float defaultValue() {
        return this.getDefaultValue();
    }

    @Deprecated
    public ControlWindow controlWindow() {
        return this._myControlWindow;
    }

    @Deprecated
    public String label() {
        return this._myCaptionLabel.toString();
    }

    @Deprecated
    public T listen() {
        this.listen(true);
        return this.me;
    }

    @Override
    @Deprecated
    public String name() {
        return this.getName();
    }

    @Override
    @Deprecated
    public int id() {
        return this._myId;
    }

    @Override
    @Deprecated
    public T setLabel(String theLabel) {
        this.setCaptionLabel(theLabel);
        return this.me;
    }

    @Deprecated
    public Label valueLabel() {
        return this._myValueLabel;
    }

    @Deprecated
    public void enableSprite() {
        if (this.sprite != null) {
            this.isSprite = true;
            this.updateDisplayMode(2);
        }
    }

    @Deprecated
    public void disableSprite() {
        this.isSprite = false;
        this.updateDisplayMode(0);
    }

    @Deprecated
    public T setAutoUpdate(boolean theValue) {
        this.listen(theValue);
        return this.me;
    }

    @Deprecated
    protected ControllerPlug controllerPlug(int theIndex) {
        return this._myControllerPlugList.get(theIndex);
    }

    @Override
    @Deprecated
    public ControllerInterface<?> parent() {
        return this._myParent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DebugView
    implements ControllerView<T> {
        DebugView() {
        }

        @Override
        public void display(PApplet theApplet, T theController) {
            if (Controller.this.inside()) {
                theApplet.fill(255.0f, 0.0f, 0.0f, 50.0f);
                theApplet.stroke(255.0f, 0.0f, 0.0f);
            } else {
                theApplet.fill(255, 50.0f);
                theApplet.stroke(255);
            }
            theApplet.pushMatrix();
            theApplet.rect(0.0f, 0.0f, (float)Controller.this.width, (float)Controller.this.height);
            theApplet.popMatrix();
        }
    }
}

