/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import processing.core.PApplet;

class PAppletWindow
extends PApplet
implements WindowListener,
ComponentListener {
    private static final long serialVersionUID = -1773456691122668251L;
    protected int width = 600;
    protected int height = 200;
    protected int x = 100;
    protected int y = 100;
    protected String _myName;
    protected String _myTitle;
    protected boolean isCoordinates = true;
    protected boolean isLoop = true;
    protected ControlWindow controlWindow;
    protected ControlP5 controlP5;
    public static final int NORMAL = 0;
    public static final int ECONOMIC = 1;
    protected int _myMode = 0;
    protected String _myRenderer = "";
    protected int _myFrameRate = 30;
    private final ControlP5 cp5;

    public PAppletWindow(ControlP5 theControlP5) {
        this.cp5 = theControlP5;
    }

    public PAppletWindow(ControlP5 theControlP5, String theName, int theWidth, int theHeight) {
        this(theControlP5, theName, theWidth, theHeight, "", 30);
    }

    public PAppletWindow(ControlP5 theControlP5, String theName, int theWidth, int theHeight, String theRenderer, int theFrameRate) {
        this.cp5 = theControlP5;
        this._myName = theName;
        this._myTitle = theName;
        this.width = theWidth;
        this.height = theHeight;
        this._myFrameRate = theFrameRate;
        this._myRenderer = theRenderer;
        this.launch();
    }

    public PAppletWindow(ControlP5 theControlP5, String theName, int theX, int theY, int theWidth, int theHeight) {
        this(theControlP5, theName, theX, theY, theWidth, theHeight, "", 30);
    }

    public PAppletWindow(ControlP5 theControlP5, String theName, int theX, int theY, int theWidth, int theHeight, String theRenderer, int theFrameRate) {
        this.cp5 = theControlP5;
        this._myName = theName;
        this._myTitle = theName;
        this.width = theWidth;
        this.height = theHeight;
        this.x = theX;
        this.y = theY;
        this._myFrameRate = theFrameRate;
        this._myRenderer = theRenderer;
        this.launch();
    }

    public void setParent(ControlP5 theControlP5) {
        this.controlP5 = theControlP5;
    }

    public void pause() {
        this.controlWindow.isAutoDraw = false;
    }

    public void play() {
        this.controlWindow.isAutoDraw = true;
    }

    public String name() {
        return this._myName;
    }

    protected void visible(boolean theValue) {
        if (theValue) {
            this.frame.show();
        } else {
            this.frame.hide();
        }
    }

    protected void resizeable(boolean theValue) {
        this.frame.setResizable(theValue);
    }

    public void setup() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this._myRenderer.length() == 0) {
            this.size(this.width, this.height);
        } else {
            this.size(this.width, this.height, this._myRenderer);
            ControlP5.logger().finer("ControlWindow: using renderer " + this._myRenderer);
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frameRate(this._myFrameRate);
    }

    protected void setControlWindow(ControlWindow theWindow) {
        this.controlWindow = theWindow;
    }

    public void draw() {
    }

    public void setTitle(String theTitle) {
        this._myTitle = theTitle;
        this.updateTitle();
    }

    protected void updateTitle() {
        String m = this._myTitle;
        if (this.isCoordinates) {
            m = m + " x:" + this.x + " y:" + this.y + "   " + this.width + "x" + this.height;
        }
        this.frame.setTitle(m);
    }

    public String title() {
        return this._myTitle;
    }

    public void showCoordinates() {
        this.isCoordinates = true;
        this.updateTitle();
    }

    public void hideCoordinates() {
        this.isCoordinates = false;
        this.updateTitle();
    }

    public void windowActivated(WindowEvent e) {
        this.isLoop = true;
        this.loop();
        try {
            this.controlP5.deactivateControllers();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent theKeyEvent) {
        this.cp5.papplet.keyPressed(theKeyEvent);
        this.cp5.keyHandler.keyEvent(theKeyEvent, this.controlWindow, false);
    }

    public void keyReleased(KeyEvent theKeyEvent) {
        this.cp5.papplet.keyReleased(theKeyEvent);
        this.cp5.keyHandler.keyEvent(theKeyEvent, this.controlWindow, false);
    }

    public void keyTyped(KeyEvent theKeyEvent) {
        this.cp5.papplet.keyTyped(theKeyEvent);
        this.cp5.keyHandler.keyEvent(theKeyEvent, this.controlWindow, false);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.controlWindow.remove();
        this.controlWindow._myApplet.stop();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
        if (this._myMode == 1) {
            this.isLoop = false;
            this.noLoop();
        }
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        Component c = e.getComponent();
        this.x = c.getLocation().x;
        this.y = c.getLocation().y;
        this.updateTitle();
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void setMode(int theValue) {
        if (theValue == 1) {
            this._myMode = 1;
            return;
        }
        this._myMode = 0;
    }

    public void dispose() {
        this.controlWindow._myApplet.stop();
        this.stop();
        this.removeAll();
        this.frame.removeAll();
        this.frame.dispose();
    }

    private void launch() {
        GraphicsDevice displayDevice = null;
        if (displayDevice == null) {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            displayDevice = environment.getDefaultScreenDevice();
        }
        this.frame = new Frame(displayDevice.getDefaultConfiguration());
        this.frame.setResizable(false);
        this.init();
        this.frame.pack();
        this.frame.setLocation(this.x, this.y);
        Insets insets = this.frame.getInsets();
        int windowW = Math.max(this.width, 128) + insets.left + insets.right;
        int windowH = Math.max(this.height, 128) + insets.top + insets.bottom;
        this.frame.setSize(windowW, windowH);
        this.frame.setLayout(null);
        this.frame.add((Component)((Object)this));
        this.frame.setBackground(Color.black);
        int usableWindowH = windowH - insets.top - insets.bottom;
        this.setBounds((windowW - this.width) / 2, insets.top + (usableWindowH - this.height) / 2, this.width, this.height);
        this.frame.addWindowListener(this);
        this.frame.addComponentListener(this);
        this.frame.setName(this._myName);
        this.frame.setTitle(this._myName + " x:" + this.x + " y:" + this.y + "   w:" + this.width + " h:" + this.height);
        this.frame.setVisible(true);
        this.requestFocus();
    }
}

