/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerView;
import controlP5.Label;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tooltip {
    private ControllerView<?> _myView;
    private PVector position = new PVector();
    private PVector currentPosition = new PVector();
    private PVector previousPosition = new PVector();
    private PVector offset = new PVector();
    private Controller<?> _myController;
    private long startTime = 0L;
    private long _myDelayInMillis = 500L;
    private int _myMode = 0;
    private int _myHeight = 20;
    private int _myBackgroundColor = -76;
    private int _myMaxAlpha = 255;
    private int _myAlpha = 0;
    private Map<Controller<?>, String> map;
    private Label _myLabel;
    private boolean enabled = true;
    private int _myBorder;
    private ControlP5 cp5;
    private int _myAlignH = 39;

    Tooltip(ControlP5 theControlP5) {
        this.cp5 = theControlP5;
        this.position = new PVector();
        this.currentPosition = new PVector();
        this.previousPosition = new PVector();
        this.offset = new PVector(0.0f, 24.0f, 0.0f);
        this.map = new HashMap();
        this._myLabel = new Label(this.cp5, "tooltip");
        this._myLabel.setColor(-16777216);
        this._myLabel.setPadding(0, 0);
        this.setView(new TooltipView());
        this.setBorder(4);
    }

    public Tooltip setBorder(int theValue) {
        this._myBorder = theValue;
        this._myLabel.getStyle().setMargin(this._myBorder, this._myBorder, this._myBorder, this._myBorder);
        return this;
    }

    public int getBorder() {
        return this._myBorder;
    }

    public Tooltip setAlpha(int theValue) {
        this._myMaxAlpha = theValue;
        return this;
    }

    private void updateText(String theText) {
        int n = 1;
        for (char c : theText.toCharArray()) {
            if (c != '\n') continue;
            ++n;
        }
        if (this._myLabel.getHeight() != this._myLabel.getLineHeight() * n) {
            this._myLabel.setHeight(this._myLabel.getLineHeight() * n);
        }
        this._myLabel.set(theText);
        this._myHeight = this._myLabel.getHeight() + 2;
    }

    void draw(ControlWindow theWindow) {
        if (this.enabled && this._myMode >= 1) {
            this.previousPosition.set(this.currentPosition);
            this.currentPosition.set((float)theWindow.mouseX, (float)theWindow.mouseY, 0.0f);
            if (this._myController != null && this._myController.getControlWindow().equals(theWindow)) {
                switch (this._myMode) {
                    case 1: {
                        if (this.moved()) {
                            this.startTime = System.nanoTime();
                        }
                        if (System.nanoTime() <= this.startTime + this._myDelayInMillis * 1000000L) break;
                        this.position.set(this.currentPosition);
                        this._myAlignH = 39;
                        if (this.position.x > (float)(this._myController.getControlWindow().papplet().width - (this.getWidth() + 20))) {
                            this.position.sub(new PVector((float)this.getWidth(), 0.0f, 0.0f));
                            this._myAlignH = 37;
                        }
                        this._myMode = 3;
                        this.startTime = System.nanoTime();
                        this._myAlpha = 0;
                        break;
                    }
                    case 3: {
                        float t1 = System.nanoTime() - this.startTime;
                        this._myAlpha = (int)PApplet.map((float)t1, (float)0.0f, (float)2.0E8f, (float)0.0f, (float)this._myMaxAlpha);
                        if (this._myAlpha < 250) break;
                        this._myMode = 4;
                        this._myAlpha = 255;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        float t2 = System.nanoTime() - this.startTime;
                        this._myAlpha = (int)PApplet.map((float)t2, (float)0.0f, (float)2.0E8f, (float)this._myMaxAlpha, (float)0.0f);
                        if (this._myAlpha > 0) break;
                        this._myMode = 6;
                        break;
                    }
                    case 6: {
                        this._myController = null;
                        this._myMode = 0;
                    }
                }
                this._myAlpha = PApplet.max((int)0, (int)PApplet.min((int)this._myAlpha, (int)this._myMaxAlpha));
                if (this._myMode >= 1) {
                    this._myAlpha = this._myMode == 1 ? 0 : this._myAlpha;
                    theWindow.papplet().pushMatrix();
                    theWindow.papplet().translate(this.position.x, this.position.y);
                    theWindow.papplet().translate(this.offset.x, this.offset.y);
                    this._myView.display(theWindow.papplet(), null);
                    theWindow.papplet().popMatrix();
                }
                if (this._myMode < 5 && this.moved()) {
                    this.deactivate(0);
                }
            }
        }
    }

    private boolean moved() {
        return PApplet.abs((float)PApplet.dist((float)this.previousPosition.x, (float)this.previousPosition.y, (float)this.currentPosition.x, (float)this.currentPosition.y)) > 1.0f;
    }

    public Tooltip setDelay(long theMillis) {
        this._myDelayInMillis = theMillis;
        return this;
    }

    protected void activate(Controller<?> theController) {
        if (this.map.containsKey(theController)) {
            this.startTime = System.nanoTime();
            this._myController = theController;
            this.currentPosition.set((float)theController.getControlWindow().mouseX, (float)theController.getControlWindow().mouseY, 0.0f);
            this.updateText(this.map.get(this._myController));
            this._myMode = 1;
        }
    }

    protected void deactivate() {
        this.deactivate(1);
    }

    protected void deactivate(int theNum) {
        if (theNum == 0) {
            if (this._myMode >= 4) {
                if (this._myMode < 5) {
                    this.startTime = System.nanoTime();
                }
                this._myMode = 5;
            }
        } else {
            this._myMode = this._myMode >= 4 ? 5 : 6;
        }
    }

    public Tooltip setView(ControllerView<?> theDisplay) {
        this._myView = theDisplay;
        return this;
    }

    public Tooltip register(Controller<?> theController, String theText) {
        this.map.put(theController, theText);
        theController.registerProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip register(String theControllerName, String theText) {
        Controller<?> c = this.cp5.getController(theControllerName);
        if (c == null) {
            return this;
        }
        this.map.put(c, theText);
        c.registerProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip unregister(Controller<?> theController) {
        this.map.remove(theController);
        theController.removeProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip unregister(String theControllerName) {
        Controller<?> c = this.cp5.getController(theControllerName);
        if (c == null) {
            return this;
        }
        return this.unregister(c);
    }

    public Tooltip setWidth(int theWidth) {
        return this;
    }

    public int getWidth() {
        return this._myLabel.getWidth();
    }

    public Tooltip setHeight(int theHeight) {
        this._myHeight = theHeight;
        return this;
    }

    public Tooltip setPositionOffset(float theX, float theY) {
        this.offset.x = theX;
        this.offset.y = theY;
        return this;
    }

    public Tooltip disable() {
        this.enabled = false;
        return this;
    }

    public Tooltip enable() {
        this.enabled = true;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Tooltip setLabel(Label theLabel) {
        this._myLabel = theLabel;
        return this;
    }

    public Label getLabel() {
        return this._myLabel;
    }

    public Tooltip setColorBackground(int theColor) {
        this._myBackgroundColor = theColor;
        return this;
    }

    public Tooltip setColorLabel(int theColor) {
        this._myLabel.setColor(theColor);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TooltipView
    implements ControllerView<Controller<?>> {
        TooltipView() {
        }

        @Override
        public void display(PApplet theApplet, Controller<?> theController) {
            theApplet.fill(Tooltip.this._myBackgroundColor, (float)Tooltip.this._myAlpha);
            theApplet.rect(0.0f, 0.0f, (float)(Tooltip.this.getWidth() + Tooltip.this._myBorder * 2), (float)(Tooltip.this._myHeight + Tooltip.this._myBorder));
            theApplet.pushMatrix();
            if (Tooltip.this._myAlignH == 39) {
                theApplet.translate(6.0f, 0.0f);
            } else {
                theApplet.translate((float)(Tooltip.this.getWidth() - 6), 0.0f);
            }
            theApplet.triangle(0.0f, 0.0f, 4.0f, -4.0f, 8.0f, 0.0f);
            theApplet.popMatrix();
            theApplet.tint(255, PApplet.map((float)Tooltip.this._myAlpha, (float)0.0f, (float)Tooltip.this._myMaxAlpha, (float)0.0f, (float)255.0f));
            Tooltip.this._myLabel.draw(theApplet, 0, 0, theController);
            theApplet.tint(255);
        }
    }
}

