/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControllerInterface;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CColor
implements Serializable {
    private int colorBackground = -16763310;
    private int colorForeground = -16750196;
    private int colorActive = -16211249;
    private int colorCaptionLabel = -1;
    private int colorValueLabel = -1;
    private int colorBackgroundAlpha = 255;
    private int colorForegroundAlpha = 255;
    private int colorActiveAlpha = 255;
    private int colorCaptionLabelAlpha = 255;
    private int colorValueLabelAlpha = 255;
    private int alpha = 255;
    private int maskA = 0xFFFFFF;
    int maskR = -16711681;
    int maskG = -65281;
    int maskB = -256;

    protected CColor set(CColor theColor) {
        this.colorBackground = theColor.colorBackground;
        this.colorForeground = theColor.colorForeground;
        this.colorActive = theColor.colorActive;
        this.colorCaptionLabel = theColor.colorCaptionLabel;
        this.colorValueLabel = theColor.colorValueLabel;
        this.colorBackgroundAlpha = theColor.colorBackgroundAlpha;
        this.colorForegroundAlpha = theColor.colorForegroundAlpha;
        this.colorActiveAlpha = theColor.colorActiveAlpha;
        this.colorCaptionLabelAlpha = theColor.colorCaptionLabelAlpha;
        this.colorValueLabelAlpha = theColor.colorValueLabelAlpha;
        return this;
    }

    protected CColor copyTo(ControllerInterface<?> theControl) {
        theControl.setColorBackground(this.colorBackground);
        theControl.setColorForeground(this.colorForeground);
        theControl.setColorActive(this.colorActive);
        theControl.setColorLabel(this.colorCaptionLabel);
        return this;
    }

    public String toString() {
        return "bg (" + (this.colorBackground >> 16 & 0xFF) + "," + (this.colorBackground >> 8 & 0xFF) + "," + (this.colorBackground >> 0 & 0xFF) + "), " + "fg (" + (this.colorForeground >> 16 & 0xFF) + "," + (this.colorForeground >> 8 & 0xFF) + "," + (this.colorForeground >> 0 & 0xFF) + "), " + "active (" + (this.colorActive >> 16 & 0xFF) + "," + (this.colorActive >> 8 & 0xFF) + "," + (this.colorActive >> 0 & 0xFF) + "), " + "captionlabel (" + (this.colorCaptionLabel >> 16 & 0xFF) + "," + (this.colorCaptionLabel >> 8 & 0xFF) + "," + (this.colorCaptionLabel >> 0 & 0xFF) + "), " + "valuelabel (" + (this.colorValueLabel >> 16 & 0xFF) + "," + (this.colorValueLabel >> 8 & 0xFF) + "," + (this.colorValueLabel >> 0 & 0xFF) + ")";
    }

    public CColor() {
        this.set(ControlP5.getColor());
    }

    public CColor(int cfg, int cbg, int cactive, int ccl, int cvl) {
        this.setForeground(cfg);
        this.setBackground(cbg);
        this.setActive(cactive);
        this.setCaptionLabel(ccl);
        this.setValueLabel(cvl);
    }

    public CColor(CColor theColor) {
        this.set(theColor);
    }

    public CColor setAlpha(int theAlpha) {
        this.alpha = theAlpha;
        this.colorBackground = this.colorBackground & this.maskA | (int)((float)this.colorBackgroundAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorForeground = this.colorForeground & this.maskA | (int)((float)this.colorForegroundAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorActive = this.colorActive & this.maskA | (int)((float)this.colorActiveAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorCaptionLabel = this.colorCaptionLabel & this.maskA | (int)((float)this.colorCaptionLabelAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorValueLabel = this.colorValueLabel & this.maskA | (int)((float)this.colorValueLabel * ((float)this.alpha / 255.0f)) << 24;
        return this;
    }

    public CColor setForeground(int theColor) {
        this.colorForegroundAlpha = theColor >> 24 & 0xFF;
        this.colorForeground = theColor & this.maskA | (this.colorForegroundAlpha & this.alpha) << 24;
        return this;
    }

    public CColor setBackground(int theColor) {
        this.colorBackgroundAlpha = theColor >> 24 & 0xFF;
        this.colorBackground = theColor & this.maskA | (this.colorBackgroundAlpha & this.alpha) << 24;
        return this;
    }

    public CColor setActive(int theColor) {
        this.colorActiveAlpha = theColor >> 24 & 0xFF;
        this.colorActive = theColor & this.maskA | (this.colorActiveAlpha & this.alpha) << 24;
        return this;
    }

    public CColor setCaptionLabel(int theColor) {
        this.colorCaptionLabelAlpha = theColor >> 24 & 0xFF;
        this.colorCaptionLabel = theColor & this.maskA | (this.colorCaptionLabelAlpha & this.alpha) << 24;
        return this;
    }

    public CColor setValueLabel(int theColor) {
        this.colorValueLabelAlpha = theColor >> 24 & 0xFF;
        this.colorValueLabel = theColor & this.maskA | (this.colorValueLabelAlpha & this.alpha) << 24;
        return this;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getForeground() {
        return this.colorForeground;
    }

    public int getBackground() {
        return this.colorBackground;
    }

    public int getActive() {
        return this.colorActive;
    }

    public int getCaptionLabel() {
        return this.colorCaptionLabel;
    }

    public int getValueLabel() {
        return this.colorValueLabel;
    }

    public int hashCode() {
        int result = 23;
        result = 37 * result + this.colorBackground;
        result = 37 * result + this.colorForeground;
        result = 37 * result + this.colorActive;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CColor cc = (CColor)o;
        return this.colorBackground == cc.colorBackground && this.colorForeground == cc.colorForeground && this.colorActive == cc.colorActive && this.colorCaptionLabel == cc.colorCaptionLabel && this.colorValueLabel == cc.colorValueLabel;
    }
}

