/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Accordion;
import controlP5.Bang;
import controlP5.Button;
import controlP5.CColor;
import controlP5.Chart;
import controlP5.CheckBox;
import controlP5.ColorPicker;
import controlP5.ControlGroup;
import controlP5.ControlKey;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerAutomator;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerLayout;
import controlP5.ControllerProperties;
import controlP5.DropdownList;
import controlP5.FieldChangedListener;
import controlP5.Group;
import controlP5.Knob;
import controlP5.ListBox;
import controlP5.Matrix;
import controlP5.MultiList;
import controlP5.Numberbox;
import controlP5.PAppletWindow;
import controlP5.RadioButton;
import controlP5.Range;
import controlP5.Slider;
import controlP5.Slider2D;
import controlP5.Tab;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import controlP5.Tooltip;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlP5Base
implements ControlP5Constants {
    private ControlP5 cp5;
    ControllerProperties _myProperties;
    private ControllerAutomator _myAutomator;
    protected Map<Object, ArrayList<ControllerInterface<?>>> _myObjectToControllerMap = new HashMap();
    protected Map<String, FieldChangedListener> _myFieldChangedListenerMap = new HashMap<String, FieldChangedListener>();
    protected ControllerGroup<?> currentGroupPointer;
    protected boolean isCurrentGroupPointerClosed = true;
    protected int autoDirection = 0;

    public Tab getDefaultTab() {
        return (Tab)this.cp5.controlWindow.getTabs().get(1);
    }

    protected void init(ControlP5 theControlP5) {
        this.cp5 = theControlP5;
        this._myProperties = new ControllerProperties(this.cp5);
        this._myAutomator = new ControllerAutomator(this.cp5);
        this.currentGroupPointer = this.cp5.controlWindow.getTab("default");
    }

    public ControllerLayout getLayout() {
        return new ControllerLayout(this.cp5);
    }

    public Tab addTab(String theName) {
        return this.addTab(this.cp5.controlWindow, theName);
    }

    public Tab addTab(PApplet theWindow, String theName) {
        return this.addTab(this.cp5.controlWindow, theName);
    }

    public Tab addTab(ControlWindow theWindow, String theName) {
        for (int i = 0; i < theWindow.getTabs().size(); ++i) {
            if (!theWindow.getTabs().get(i).getName().equals(theName)) continue;
            return (Tab)theWindow.getTabs().get(i);
        }
        Tab myTab = new Tab(this.cp5, theWindow, theName);
        theWindow.getTabs().add(myTab);
        return myTab;
    }

    public Button addButton(Object theObject, String theIndex, String theName, float theValue, int theX, int theY, int theW, int theH) {
        Button myController = new Button(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), theName, theValue, theX, theY, theW, theH);
        this.cp5.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        myController.getProperty("value").disable();
        return myController;
    }

    public Button addButton(String theName, float theValue, int theX, int theY, int theW, int theH) {
        return this.addButton(null, "", theName, theValue, theX, theY, theW, theH);
    }

    public Bang addBang(Object theObject, String theIndex, String theName, int theX, int theY, int theWidth, int theHeight) {
        Bang myController = new Bang(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theWidth, theHeight);
        this.cp5.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        myController.getProperty("value").disable();
        return myController;
    }

    public Bang addBang(String theName, int theX, int theY) {
        return this.addBang(null, "", theName, theX, theY, 20, 20);
    }

    public Bang addBang(String theName) {
        return this.addBang(null, "", theName);
    }

    public Bang addBang(String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addBang(null, "", theName, theX, theY, theWidth, theHeight);
    }

    public Toggle addToggle(Object theObject, String theIndex, String theName, boolean theDefaultValue, float theX, float theY, int theWidth, int theHeight) {
        Toggle myController = new Toggle(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theDefaultValue ? 1.0f : 0.0f, theX, theY, theWidth, theHeight);
        this.cp5.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public Toggle addToggle(String theName, boolean theDefaultValue, float theX, float theY, int theWidth, int theHeight) {
        return this.addToggle(null, "", theName, theDefaultValue, theX, theY, theWidth, theHeight);
    }

    public Toggle addToggle(String theName, float theX, float theY, int theWidth, int theHeight) {
        return this.addToggle(null, "", theName, false, theX, theY, theWidth, theHeight);
    }

    public Toggle addToggle(Object theObject, String theIndex, String theName, float theX, float theY, int theWidth, int theHeight) {
        return this.addToggle(theObject, theIndex, theName, false, theX, theY, theWidth, theHeight);
    }

    public Tooltip addTooltip() {
        return null;
    }

    public Matrix addMatrix(Object theObject, String theIndex, String theName, int theCellX, int theCellY, int theX, int theY, int theWidth, int theHeight) {
        Matrix myController = new Matrix(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theCellX, theCellY, theX, theY, theWidth, theHeight);
        this.cp5.register(theObject, theIndex, myController);
        ((Matrix)myController.registerProperty("cells")).registerProperty("interval");
        return myController;
    }

    public Matrix addMatrix(String theName) {
        return this.addMatrix(theName, 10, 10, 0, 0, 100, 100);
    }

    public Matrix addMatrix(String theName, int theCellX, int theCellY, int theX, int theY, int theWidth, int theHeight) {
        return this.addMatrix(null, "", theName, theCellX, theCellY, theX, theY, theWidth, theHeight);
    }

    public Slider2D addSlider2D(String theName) {
        return this.addSlider2D(theName, 0, 0, 99, 99);
    }

    public Slider2D addSlider2D(Object theObject, String theIndex, String theName, float theMinX, float theMaxX, float theMinY, float theMaxY, float theDefaultValueX, float theDefaultValueY, int theX, int theY, int theW, int theH) {
        Slider2D myController = new Slider2D(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.cp5.register(theObject, theIndex, myController);
        myController.setMinX(theMinX);
        myController.setMaxX(theMaxX);
        myController.setMinY(theMinY);
        myController.setMaxY(theMaxY);
        myController.setArrayValue(new float[]{theDefaultValueX, theDefaultValueY});
        myController.updateValue();
        ((Slider2D)((Slider2D)((Slider2D)((Slider2D)myController.registerProperty("arrayValue")).registerProperty("minX")).registerProperty("maxX")).registerProperty("minY")).registerProperty("maxY");
        return myController;
    }

    public Slider2D addSlider2D(String theName, int theX, int theY, int theW, int theH) {
        return this.addSlider2D(null, "", theName, 0.0f, theW, 0.0f, theH, 0.0f, 0.0f, theX, theY, theW, theH);
    }

    public Slider2D addSlider2D(Object theObject, String theIndex, String theName, int theX, int theY, int theW, int theH) {
        return this.addSlider2D(theObject, theIndex, theName, 0.0f, theW, 0.0f, theH, 0.0f, 0.0f, theX, theY, theW, theH);
    }

    public Slider2D addSlider2D(String theName, float theMinX, float theMaxX, float theMinY, float theMaxY, float theDefaultValueX, float theDefaultValueY, int theX, int theY, int theW, int theH) {
        return this.addSlider2D(null, "", theName, theMinX, theMaxX, theMinY, theMaxY, theDefaultValueX, theDefaultValueY, theX, theY, theW, theH);
    }

    public Slider addSlider(Object theObject, String theIndex, String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theW, int theH) {
        Slider myController = new Slider(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), theName, theMin, theMax, theDefaultValue, theX, theY, theW, theH);
        this.cp5.register(theObject, theIndex, myController);
        ((Slider)((Slider)myController.registerProperty("value")).registerProperty("min")).registerProperty("max");
        return myController;
    }

    public Slider addSlider(String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theW, int theH) {
        return this.addSlider(null, "", theName, theMin, theMax, theDefaultValue, theX, theY, theW, theH);
    }

    public Slider addSlider(String theName, float theMin, float theMax, int theX, int theY, int theWidth, int theHeight) {
        return this.addSlider(null, "", theName, theMin, theMax, theMin, theX, theY, theWidth, theHeight);
    }

    public Slider addSlider(Object theObject, String theIndex, String theName, float theMin, float theMax, int theX, int theY, int theW, int theH) {
        return this.addSlider(theObject, theIndex, theName, theMin, theMax, theMin, theX, theY, theW, theH);
    }

    public Range addRange(String theName) {
        return this.addRange(theName, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
    }

    public Range addRange(Object theObject, String theIndex, String theName, float theMin, float theMax, float theDefaultMinValue, float theDefaultMaxValue, int theX, int theY, int theW, int theH) {
        Range myController = new Range(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), theName, theMin, theMax, theDefaultMinValue, theDefaultMaxValue, theX, theY, theW, theH);
        this.cp5.register(theObject, theIndex, myController);
        ((Range)myController.registerProperty("lowValue")).registerProperty("highValue");
        return myController;
    }

    public Range addRange(String theName, float theMin, float theMax, float theDefaultMinValue, float theDefaultMaxValue, int theX, int theY, int theW, int theH) {
        return this.addRange(null, "", theName, theMin, theMax, theDefaultMinValue, theDefaultMaxValue, theX, theY, theW, theH);
    }

    public Range addRange(String theName, float theMin, float theMax, int theX, int theY, int theWidth, int theHeight) {
        return this.addRange(null, "", theName, theMin, theMax, theMin, theMax, theX, theY, theWidth, theHeight);
    }

    public Range addRange(Object theObject, String theIndex, String theName, float theMin, float theMax, int theX, int theY, int theWidth, int theHeight) {
        return this.addRange(theObject, theIndex, theName, theMin, theMax, theMin, theMax, theX, theY, theWidth, theHeight);
    }

    public Numberbox addNumberbox(Object theObject, String theIndex, String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        Numberbox myController = new Numberbox(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theDefaultValue, theX, theY, theWidth, theHeight);
        this.cp5.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public Numberbox addNumberbox(String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addNumberbox(null, "", theName, Float.NaN, theX, theY, theWidth, theHeight);
    }

    public Numberbox addNumberbox(Object theObject, String theIndex, String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addNumberbox(theObject, theIndex, theName, Float.NaN, theX, theY, theWidth, theHeight);
    }

    public Numberbox addNumberbox(String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        return this.addNumberbox(null, "", theName, theDefaultValue, theX, theY, theWidth, theHeight);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theDiameter) {
        Knob myController = new Knob(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theMin, theMax, theDefaultValue, theX, theY, theDiameter);
        this.cp5.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public Knob addKnob(String theName, float theMin, float theMax, int theX, int theY, int theDiameter) {
        return this.addKnob(null, "", theName, theMin, theMax, theMin, theX, theY, theDiameter);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName, float theMin, float theMax, int theX, int theY, int theDiameter) {
        return this.addKnob(theObject, theIndex, theName, theMin, theMax, theX, theY, theDiameter);
    }

    public Knob addKnob(String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theDiameter) {
        return this.addKnob(null, "", theName, theMin, theMax, theDefaultValue, theX, theY, theDiameter);
    }

    public MultiList addMultiList(Object theObject, String theIndex, String theName, int theX, int theY, int theWidth, int theHeight) {
        MultiList myController = new MultiList(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theWidth, theHeight);
        this.cp5.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public MultiList addMultiList(String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addMultiList(null, "", theName, theX, theY, theWidth, theHeight);
    }

    public Textlabel addTextlabel(String theName) {
        return this.addTextlabel(theName, "", 0, 0);
    }

    public Textlabel addTextlabel(Object theObject, String theIndex, String theName, String theText, int theX, int theY) {
        Textlabel myController = new Textlabel(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theText, theX, theY);
        this.cp5.register(theObject, theIndex, myController);
        ((Textlabel)myController.registerProperty("value")).registerProperty("stringValue");
        return myController;
    }

    public Textlabel addTextlabel(String theName, String theText, int theX, int theY) {
        return this.addTextlabel(null, "", theName, theText, theX, theY);
    }

    public Textlabel addTextlabel(Object theObject, String theIndex, String theName, String theText) {
        return this.addTextlabel(theObject, theIndex, theName, theText, 0, 0);
    }

    public Textlabel addTextlabel(String theName, String theText) {
        return this.addTextlabel(null, "", theName, theText, 0, 0);
    }

    public Textarea addTextarea(String theName) {
        return this.addTextarea(theName, "", 0, 0, 199, 99);
    }

    public Textarea addTextarea(String theName, String theText, int theX, int theY, int theW, int theH) {
        Textarea myController = new Textarea(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theText, theX, theY, theW, theH);
        this.cp5.register(null, "", myController);
        myController.registerProperty("text");
        return myController;
    }

    public Textfield addTextfield(String theIndex) {
        return this.addTextfield(theIndex, 0, 0, 199, 19);
    }

    public Textfield addTextfield(Object theObject, String theIndex, String theName, int theX, int theY, int theW, int theH) {
        Textfield myController = new Textfield(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, "", theX, theY, theW, theH);
        this.cp5.register(theObject, theIndex, myController);
        myController.registerProperty("text");
        return myController;
    }

    public Textfield addTextfield(String theName, int theX, int theY, int theW, int theH) {
        return this.addTextfield(null, "", theName, theX, theY, theW, theH);
    }

    public Textfield addTextfield(Object theObject, String theIndex, String theName) {
        return this.addTextfield(theObject, theIndex, theName, 0, 0, 99, 19);
    }

    public Accordion addAccordion(String theName) {
        Accordion myController = new Accordion(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, 0, 0, 200);
        this.cp5.register(null, "", myController);
        return myController;
    }

    public Accordion addAccordion(String theName, int theX, int theY, int theWidth) {
        Accordion myController = new Accordion(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theWidth);
        this.cp5.register(null, "", myController);
        return myController;
    }

    public RadioButton addRadioButton(String theName) {
        return this.addRadioButton(theName, 0, 0);
    }

    public RadioButton addRadioButton(String theName, int theX, int theY) {
        RadioButton myController = new RadioButton(this.cp5, (ControllerGroup<?>)((Tab)this.cp5.controlWindow.getTabs().get(1)), theName, theX, theY);
        this.cp5.register(null, "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public RadioButton addRadio(String theName) {
        return this.addRadioButton(theName, 0, 0);
    }

    public RadioButton addRadio(String theName, int theX, int theY) {
        RadioButton myController = new RadioButton(this.cp5, (ControllerGroup<?>)((Tab)this.cp5.controlWindow.getTabs().get(1)), theName, theX, theY);
        this.cp5.register(null, "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public CheckBox addCheckBox(String theName) {
        return this.addCheckBox(theName, 0, 0);
    }

    public CheckBox addCheckBox(String theName, int theX, int theY) {
        CheckBox myController = new CheckBox(this.cp5, (ControllerGroup<?>)((Tab)this.cp5.controlWindow.getTabs().get(1)), theName, theX, theY);
        this.cp5.register(null, "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public ListBox addListBox(String theName) {
        return this.addListBox(theName, 0, 0, 99, 199);
    }

    public ListBox addListBox(String theName, int theX, int theY, int theW, int theH) {
        ListBox myController = new ListBox(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.cp5.register(null, "", myController);
        ((ListBox)myController.registerProperty("listBoxItems")).registerProperty("value");
        return myController;
    }

    public DropdownList addDropdownList(String theName) {
        return this.addDropdownList(theName, 0, 0, 99, 99);
    }

    public DropdownList addDropdownList(String theName, int theX, int theY, int theW, int theH) {
        DropdownList myController = new DropdownList(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.cp5.register(null, "", myController);
        ((DropdownList)myController.registerProperty("listBoxItems")).registerProperty("value");
        return myController;
    }

    public ColorPicker addColorPicker(String theName) {
        return this.addColorPicker(theName, 0, 0, 255, 10);
    }

    public ColorPicker addColorPicker(String theName, int theX, int theY, int theW, int theH) {
        ColorPicker myController = new ColorPicker(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.cp5.register(null, "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public Chart addChart(String theName) {
        return this.addChart(theName, 0, 0, 200, 100);
    }

    public Chart addChart(String theName, int theX, int theY, int theW, int theH) {
        Chart myController = new Chart(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.cp5.register(null, "", myController);
        return myController;
    }

    public Group addGroup(Object theObject, String theIndex, String theName, int theX, int theY, int theW) {
        Group myController = new Group(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), theName, theX, theY, theW, 9);
        this.cp5.register(theObject, theIndex, myController);
        return myController;
    }

    public Group addGroup(String theName, int theX, int theY, int theW) {
        return this.addGroup(null, "", theName, theX, theY, theW);
    }

    public Group addGroup(String theName) {
        return this.addGroup(theName, 0, 0);
    }

    public Group addGroup(String theName, int theX, int theY) {
        return this.addGroup(null, "", theName, theX, theY, 99);
    }

    public ControlWindow addControlWindow(String theWindowName, int theX, int theY, int theWidth, int theHeight, String theRenderer, int theFrameRate) {
        for (int i = 0; i < this.cp5.controlWindowList.size(); ++i) {
            if (!this.cp5.controlWindowList.get(i).name().equals(theWindowName)) continue;
            ControlP5.logger().warning("ControlWindow with name " + theWindowName + " already exists. overwriting now.");
        }
        PAppletWindow myPAppletWindow = new PAppletWindow(this.cp5, theWindowName, theX, theY, theWidth, theHeight, theRenderer, theFrameRate);
        myPAppletWindow.setParent(this.cp5);
        myPAppletWindow.setMode(1);
        ControlWindow myControlWindow = new ControlWindow(this.cp5, myPAppletWindow);
        this.cp5.controlWindowList.add(myControlWindow);
        return myControlWindow;
    }

    public ControlWindow addControlWindow(String theWindowName, int theWidth, int theHeight) {
        return this.addControlWindow(theWindowName, 100, 100, theWidth, theHeight, "", 30);
    }

    public ControlWindow addControlWindow(String theWindowName, int theX, int theY, int theWidth, int theHeight) {
        return this.addControlWindow(theWindowName, theX, theY, theWidth, theHeight, "", 30);
    }

    public ControlWindow addControlWindow(String theWindowName, int theX, int theY, int theWidth, int theHeight, int theFrameRate) {
        return this.addControlWindow(theWindowName, theX, theY, theWidth, theHeight, "", theFrameRate);
    }

    public Textlabel getTextlabel(String theText, int theX, int theY) {
        return new Textlabel(this.cp5, theText, theX, theY);
    }

    public Textlabel getTextlabel() {
        return this.getTextlabel("", 0, 0);
    }

    protected void setCurrentPointer(ControllerGroup<?> theGroup) {
        this.currentGroupPointer = theGroup;
        this.isCurrentGroupPointerClosed = false;
    }

    protected void releaseCurrentPointer(ControllerGroup<?> theGroup) {
        if (!this.isCurrentGroupPointerClosed) {
            this.currentGroupPointer = theGroup;
            this.isCurrentGroupPointerClosed = true;
        } else {
            ControlP5.logger().warning("use .end() first before using .begin() again.");
        }
    }

    public void setAutoAddDirection(int theDirection) {
        if (theDirection == 0) {
            this.autoDirection = 0;
            return;
        }
        this.autoDirection = 1;
    }

    public void setAutoSpacing() {
        Controller.autoSpacing.x = 10.0f;
        Controller.autoSpacing.y = 10.0f;
        Controller.autoSpacing.z = 0.0f;
    }

    public void setAutoSpacing(float theX) {
        Controller.autoSpacing.x = theX;
    }

    public void setAutoSpacing(float theX, float theY) {
        Controller.autoSpacing.x = theX;
        Controller.autoSpacing.y = theY;
    }

    public void setAutoSpacing(float theX, float theY, float theZ) {
        Controller.autoSpacing.x = theX;
        Controller.autoSpacing.y = theY;
        Controller.autoSpacing.z = theZ;
    }

    protected void linebreak(Controller<?> theController, boolean theFlag, int theW, int theH, PVector theSpacing) {
        if (this.currentGroupPointer.autoPosition.x + Controller.autoSpacing.x + (float)theW > (float)this.cp5.papplet.width) {
            this.currentGroupPointer.autoPosition.y += this.currentGroupPointer.tempAutoPositionHeight;
            this.currentGroupPointer.autoPosition.x = this.currentGroupPointer.autoPositionOffsetX;
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
            theController.position.x = this.currentGroupPointer.autoPosition.x;
            theController.position.y = this.currentGroupPointer.autoPosition.y;
            theFlag = false;
        }
        if (theFlag) {
            this.currentGroupPointer.autoPosition.y += this.currentGroupPointer.tempAutoPositionHeight;
            this.currentGroupPointer.autoPosition.x = this.currentGroupPointer.autoPositionOffsetX;
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
        } else {
            if (theController instanceof Slider) {
                this.currentGroupPointer.autoPosition.x += (float)theController.getCaptionLabel().getWidth();
            }
            this.currentGroupPointer.autoPosition.x += Controller.autoSpacing.x + (float)theW;
            if ((float)theH + theSpacing.y > this.currentGroupPointer.tempAutoPositionHeight) {
                this.currentGroupPointer.tempAutoPositionHeight = (float)theH + theSpacing.y;
            }
        }
    }

    public Slider addSlider(String theName) {
        return this.addSlider(theName, 0.0f, 100.0f);
    }

    public Slider addSlider(Object theObject, String theIndex, String theName) {
        return this.addSlider(theObject, theIndex, theName, 0.0f, 100.0f);
    }

    public Slider addSlider(String theName, float theMin, float theMax) {
        return this.addSlider(null, "", theName, theMin, theMax);
    }

    public Slider addSlider(Object theObject, String theIndex, String theName, float theMin, float theMax) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Slider s = this.addSlider(theObject, theIndex, theName, theMin, theMax, theMin, x, y, Slider.autoWidth, Slider.autoHeight);
        this.linebreak(s, false, Slider.autoWidth, Slider.autoHeight, Slider.autoSpacing);
        s.moveTo(this.currentGroupPointer);
        if (this.autoDirection == 1) {
            s.linebreak();
        }
        return s;
    }

    public Button addButton(String theName) {
        return this.addButton(null, "", theName, 1.0f);
    }

    public Button addButton(Object theObject, String theIndex, String theName) {
        return this.addButton(theObject, theIndex, theName, 1.0f);
    }

    public Button addButton(String theName, float theValue) {
        return this.addButton(null, "", theName, theValue);
    }

    public Button addButton(Object theObject, String theIndex, String theName, float theValue) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Button b = this.addButton(theObject, theIndex, theName, theValue, x, y, Button.autoWidth, Button.autoHeight);
        this.linebreak(b, false, Button.autoWidth, Button.autoHeight, Button.autoSpacing);
        b.moveTo(this.currentGroupPointer);
        return b;
    }

    public Bang addBang(Object theObject, String theIndex, String theName) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Bang b = this.addBang(theObject, theIndex, theName, x, y, Bang.autoWidth, Bang.autoHeight);
        this.linebreak(b, false, Bang.autoWidth, Bang.autoHeight, Bang.autoSpacing);
        b.moveTo(this.currentGroupPointer);
        return b;
    }

    public Toggle addToggle(String theName) {
        return this.addToggle(null, "", theName);
    }

    public Toggle addToggle(String theName, boolean theValue) {
        return this.addToggle(null, "", theName, theValue);
    }

    public Toggle addToggle(Object theObject, String theIndex, String theName) {
        return this.addToggle(theObject, theIndex, theName, false);
    }

    public Toggle addToggle(Object theObject, String theIndex, String theName, boolean theValue) {
        Toggle t = this.addToggle(theObject, theIndex, theName, theValue, this.currentGroupPointer.autoPosition.x, this.currentGroupPointer.autoPosition.y, Toggle.autoWidth, Toggle.autoHeight);
        this.linebreak(t, false, Toggle.autoWidth, Toggle.autoHeight, t.autoSpacing);
        t.moveTo(this.currentGroupPointer);
        return t;
    }

    public Numberbox addNumberbox(Object theObject, String theIndex, String theName) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Numberbox n = this.addNumberbox(theObject, theIndex, theName, x, y, Numberbox.autoWidth, Numberbox.autoHeight);
        this.linebreak(n, false, Numberbox.autoWidth, Numberbox.autoHeight, n.autoSpacing);
        n.moveTo(this.currentGroupPointer);
        return n;
    }

    public Numberbox addNumberbox(String theName) {
        return this.addNumberbox(null, "", theName);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName, int theMin, int theMax) {
        Knob n = this.addKnob(theObject, theIndex, theName, theMin, theMax, theMin, (int)this.currentGroupPointer.autoPosition.x, (int)this.currentGroupPointer.autoPosition.y, Knob.autoWidth);
        this.linebreak(n, false, Knob.autoWidth, Knob.autoHeight, n.autoSpacing);
        n.moveTo(this.currentGroupPointer);
        return n;
    }

    public Knob addKnob(String theName) {
        return this.addKnob(theName, 0, 100);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName) {
        return this.addKnob(theObject, theIndex, theName, 0, 100);
    }

    public Knob addKnob(String theName, int theMin, int theMax) {
        return this.addKnob(null, "", theName, theMin, theMax);
    }

    public ControlWindow addControlWindow(String theName) {
        return this.addControlWindow(theName, 20, 20, 300, 400);
    }

    public <C> C addController(Object theObject, String theIndex, String theName, Class<C> theClass, int theX, int theY) {
        Controller c = null;
        if (theClass.equals(Slider.class)) {
            c = this.addSlider(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 0, 0, 99, 9);
        } else if (theClass.equals(Bang.class)) {
            c = this.addBang(theObject, theIndex, theName, 0, 0, 19, 19);
        } else if (theClass.equals(Button.class)) {
            c = this.addButton(theObject, theIndex, theName, 0.0f, 0, 0, 49, 19);
        } else if (theClass.equals(Knob.class)) {
            c = this.addKnob(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 0, 0, 49);
        } else if (theClass.equals(Numberbox.class)) {
            c = this.addNumberbox(theObject, theIndex, theName, 0.0f, 0, 0, 99, 19);
        } else if (theClass.equals(Toggle.class)) {
            c = this.addToggle(theObject, theIndex, theName, false, 0.0f, 0.0f, 49, 19);
        } else if (theClass.equals(Textfield.class)) {
            c = this.addTextfield(theObject, theIndex, theName, 0, 0, 99, 19);
        } else if (theClass.equals(Range.class)) {
            c = this.addRange(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
        } else if (theClass.equals(Slider2D.class)) {
            c = this.addSlider2D(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0, 0, 99, 99);
        } else if (theClass.equals(Textlabel.class)) {
            c = this.addTextlabel(theName, "<empty>");
        }
        c.setPosition(theX, theY);
        return (C)c;
    }

    @ControlP5.Invisible
    public <C> C addGroup(Object theObject, String theIndex, String theName, Class<C> theClass, int theX, int theY, int theW, int theH) {
        ControlGroup c = null;
        if (theClass.equals(DropdownList.class)) {
            c = this.addDropdownList(theName, theX, theY, theW, theH);
        } else if (theClass.equals(ListBox.class)) {
            c = this.addListBox(theName, theX, theY, theW, theH);
        } else if (theClass.equals(ListBox.class)) {
            c = this.addListBox(theName, theX, theY, theW, theH);
        } else if (theClass.equals(RadioButton.class)) {
            c = this.addRadioButton(theName, theX, theY);
        } else if (theClass.equals(CheckBox.class)) {
            c = this.addCheckBox(theName, theX, theY);
        } else if (theClass.equals(ControlGroup.class)) {
            c = this.addGroup(theName, theX, theY);
        } else if (theClass.equals(Group.class)) {
            c = this.addGroup(theName, theX, theY);
        }
        c.setPosition(theX, theY);
        ((ControllerGroup)c).setWidth(theW);
        ((ControllerGroup)c).setHeight(theH);
        return (C)c;
    }

    public <C> C addController(String theName, Class<C> theClass, int theX, int theY) {
        return this.addController(null, "", theName, theClass, theX, theY);
    }

    public ControlP5Base addControllersFor(PApplet theApplet) {
        this.addControllersFor("", theApplet);
        return this;
    }

    public ControlP5Base addControllersFor(String theAddressSpace, Object t) {
        this._myAutomator.addControllersFor(theAddressSpace, t);
        return this;
    }

    public Controller<?> getController(String theName, Object theObject) {
        if (this._myObjectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this._myObjectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                if (!c.getName().equals(theName)) continue;
                return (Controller)c;
            }
        }
        return null;
    }

    public Object getObjectForController(ControllerInterface theController) {
        for (Map.Entry<Object, ArrayList<ControllerInterface<?>>> entry : this._myObjectToControllerMap.entrySet()) {
            Object key = entry.getKey();
            ArrayList<ControllerInterface<?>> value = entry.getValue();
            for (ControllerInterface<?> c : value) {
                if (!c.equals(theController)) continue;
                return key;
            }
        }
        return null;
    }

    public ControlP5Base setPosition(int theX, int theY, Object o) {
        if (o != null && this._myObjectToControllerMap.containsKey(o)) {
            ArrayList<ControllerInterface<?>> cs = this._myObjectToControllerMap.get(o);
            for (ControllerInterface<?> c : cs) {
                int x = (int)c.getPosition().x + theX;
                int y = (int)c.getPosition().y + theY;
                c.setPosition(x, y);
            }
        }
        return this;
    }

    public ControlP5Base hide(Object theObject) {
        if (theObject != null && this._myObjectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this._myObjectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.hide();
            }
        }
        return this;
    }

    public ControlP5Base show(Object theObject) {
        if (theObject != null && this._myObjectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this._myObjectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.show();
            }
        }
        return this;
    }

    public ControlP5Base remove(Object theObject) {
        if (theObject != null && this._myObjectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this._myObjectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.remove();
            }
        }
        return this;
    }

    public ControlP5Base setColor(CColor theColor, Object theObject) {
        if (this._myObjectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this._myObjectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.setColor(theColor);
            }
        }
        return this;
    }

    public ControlP5Base listenTo(String theFieldName, Object theObject) {
        String key = theObject.hashCode() + "" + theFieldName.hashCode();
        FieldChangedListener value = new FieldChangedListener(this.cp5);
        value.listenTo(theObject, theFieldName);
        this._myFieldChangedListenerMap.put(key, value);
        return this;
    }

    public ControlP5Base stopListeningTo(String theFieldName, Object theObject) {
        String key = theObject.hashCode() + "" + theFieldName.hashCode();
        this._myFieldChangedListenerMap.remove(key);
        return this;
    }

    public ControlP5Base moveTo(ControllerGroup<?> theController, Object theObject) {
        if (this._myObjectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this._myObjectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.moveTo(theController);
            }
        }
        return this;
    }

    public ControllerProperties getProperties() {
        return this._myProperties;
    }

    public void removeProperty(ControllerInterface<?> theController) {
        this._myProperties.remove(theController);
    }

    public static void printPublicMethodsFor(Class<?> theClass, String ... thePattern) {
        Set<String> set = ControlP5Base.getPublicMethodsFor(theClass, true, thePattern);
        String str = "";
        str = str + "/**\n";
        str = str + "* ControlP5 " + theClass.getSimpleName() + "\n";
        str = str + "*\n";
        str = str + "*\n";
        str = str + "* find a list of public methods available for the " + theClass.getSimpleName() + " Controller\n";
        str = str + "* at the bottom of this sketch.\n";
        str = str + "*\n";
        str = str + "* by Andreas Schlegel, 2012\n";
        str = str + "* www.sojamo.de/libraries/controlp5\n";
        str = str + "*\n";
        str = str + "*/\n\n";
        str = str + "/*\n";
        str = str + "a list of all methods available for the " + theClass.getSimpleName() + " Controller\n";
        str = str + "use ControlP5.printPublicMethodsFor(" + theClass.getSimpleName() + ".class);\n";
        str = str + "to print the following list into the console.\n\n";
        str = str + "You can find further details about class " + theClass.getSimpleName() + " in the javadoc.\n\n";
        str = str + "Format:\n";
        str = str + "ClassName : returnType methodName(parameter type)\n\n\n";
        for (String s : set) {
            str = str + s + "\n";
        }
        str = str + "\n\n*/\n\n";
        System.out.println(str);
    }

    public static void printPublicMethodsFor(Class<?> theClass) {
        ControlP5Base.printPublicMethodsFor(theClass, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass) {
        return ControlP5Base.getPublicMethodsFor(theClass, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass, String ... thePattern) {
        return ControlP5Base.getPublicMethodsFor(theClass, true, thePattern);
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass, boolean theFlag) {
        return ControlP5Base.getPublicMethodsFor(theClass, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass, boolean isSuperclass, String ... thePattern) {
        TreeSet<String> s = new TreeSet<String>();
        Class<?> c = theClass;
        while (c != null) {
            for (Method method : c.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Deprecated.class) || method.isAnnotationPresent(ControlP5.Invisible.class) || method.getModifiers() != 1) continue;
                for (String p : thePattern) {
                    if (p.length() > 0 && !method.getName().toLowerCase().contains(p.toLowerCase())) continue;
                    String params = "";
                    for (Class<?> t : method.getParameterTypes()) {
                        params = params + t.getSimpleName() + ", ";
                    }
                    if (params.length() > 0) {
                        params = params.substring(0, params.length() - 2);
                    }
                    s.add(c.getCanonicalName() + " : " + method.getReturnType().getSimpleName().replace("Object", theClass.getSimpleName()) + " " + method.getName() + "(" + params + ") ");
                }
            }
            if (isSuperclass) {
                c = c.getSuperclass();
                continue;
            }
            c = null;
        }
        return s;
    }

    public ControlP5 mapKeyFor(ControlKey theKey, int ... theChar) {
        char[] n = this.fromIntToChar(theChar);
        this.cp5.keyHandler.mapKeyFor(theKey, n);
        this.cp5.enableShortcuts();
        return this.cp5;
    }

    private char[] fromIntToChar(int ... theChar) {
        char[] n = new char[theChar.length];
        for (int i = 0; i < n.length; ++i) {
            if (theChar[i] >= 97 && theChar[i] <= 122) {
                int n2 = i;
                theChar[n2] = theChar[n2] - 32;
            }
            n[i] = (char)theChar[i];
        }
        return n;
    }

    public ControlP5 removeKeyFor(ControlKey theKey, int ... theChar) {
        this.cp5.keyHandler.removeKeyFor(theKey, this.fromIntToChar(theChar));
        return this.cp5;
    }

    public ControlP5 removeKeysFor(int ... theChar) {
        this.cp5.keyHandler.removeKeysFor(this.fromIntToChar(theChar));
        return this.cp5;
    }
}

