/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.Controller;
import controlP5.ControllerInterface;
import controlP5.ControllerProperty;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerProperties {
    public static final int OPEN = 0;
    public static final int CLOSE = 1;
    public static String defaultName = "controlP5";
    public static Format format;
    private Map<ControllerProperty, HashSet<String>> allProperties;
    private Set<String> allSets;
    private ControlP5 controlP5;
    private String _myDefaultSetName;
    public static final Logger logger;
    private Map<String, Set<ControllerProperty>> _mySnapshots;

    public ControllerProperties(ControlP5 theControlP5) {
        Format.SERIALIZED.set(new SerializedFormat());
        Format.XML.set(new XMLFormat());
        Format.JSON.set(new JSONFormat());
        this._myDefaultSetName = "default";
        this.controlP5 = theControlP5;
        this.setFormat(Format.SERIALIZED);
        this.allProperties = new HashMap<ControllerProperty, HashSet<String>>();
        this.allSets = new HashSet<String>();
        this.addSet(this._myDefaultSetName);
        this._mySnapshots = new LinkedHashMap<String, Set<ControllerProperty>>();
    }

    public Map<ControllerProperty, HashSet<String>> get() {
        return this.allProperties;
    }

    public ControllerProperty register(ControllerInterface<?> theController, String thePropertySetter, String thePropertyGetter) {
        ControllerProperty p = new ControllerProperty(theController, thePropertySetter, thePropertyGetter);
        if (!this.allProperties.containsKey(p)) {
            this.allProperties.put(p, new HashSet());
            this.allProperties.get(p).add(this._myDefaultSetName);
        }
        return p;
    }

    public ControllerProperties register(ControllerInterface<?> theController, String theProperty) {
        theProperty = Character.toUpperCase(theProperty.charAt(0)) + theProperty.substring(1);
        this.register(theController, "set" + theProperty, "get" + theProperty);
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> theController, String theSetter, String theGetter) {
        ControllerProperty cp = new ControllerProperty(theController, theSetter, theGetter);
        this.allProperties.remove(cp);
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> theController) {
        ArrayList<ControllerProperty> list = new ArrayList<ControllerProperty>(this.allProperties.keySet());
        for (ControllerProperty cp : list) {
            if (!cp.getController().equals(theController)) continue;
            this.allProperties.remove(cp);
        }
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> theController, String theProperty) {
        return this.remove(theController, "set" + theProperty, "get" + theProperty);
    }

    public List<ControllerProperty> get(ControllerInterface<?> theController) {
        ArrayList<ControllerProperty> props = new ArrayList<ControllerProperty>();
        ArrayList<ControllerProperty> list = new ArrayList<ControllerProperty>(this.allProperties.keySet());
        for (ControllerProperty cp : list) {
            if (!cp.getController().equals(theController)) continue;
            props.add(cp);
        }
        return props;
    }

    public ControllerProperty getProperty(ControllerInterface<?> theController, String theSetter, String theGetter) {
        ControllerProperty cp = new ControllerProperty(theController, theSetter, theGetter);
        for (ControllerProperty p : this.allProperties.keySet()) {
            if (!p.equals(cp)) continue;
            return p;
        }
        return this.register(theController, theSetter, theGetter);
    }

    public ControllerProperty getProperty(ControllerInterface<?> theController, String theProperty) {
        theProperty = Character.toUpperCase(theProperty.charAt(0)) + theProperty.substring(1);
        return this.getProperty(theController, "set" + theProperty, "get" + theProperty);
    }

    public HashSet<ControllerProperty> getPropertySet(ControllerInterface<?> theController) {
        HashSet<ControllerProperty> set = new HashSet<ControllerProperty>();
        for (ControllerProperty p : this.allProperties.keySet()) {
            if (!p.getController().equals(theController)) continue;
            set.add(p);
        }
        return set;
    }

    public ControllerProperties addSet(String theSet) {
        this.allSets.add(theSet);
        return this;
    }

    public ControllerProperties move(ControllerProperty theProperty, String fromSet, String toSet) {
        if (!this.exists(theProperty)) {
            return this;
        }
        if (this.allProperties.containsKey(theProperty)) {
            if (this.allProperties.get(theProperty).contains(fromSet)) {
                this.allProperties.get(theProperty).remove(fromSet);
            }
            this.addSet(toSet);
            this.allProperties.get(theProperty).add(toSet);
        }
        return this;
    }

    public ControllerProperties move(ControllerInterface<?> theController, String fromSet, String toSet) {
        HashSet<ControllerProperty> set = this.getPropertySet(theController);
        for (ControllerProperty cp : set) {
            this.move(cp, fromSet, toSet);
        }
        return this;
    }

    public ControllerProperties copy(ControllerProperty theProperty, String ... theSet) {
        if (!this.exists(theProperty)) {
            return this;
        }
        for (String s : theSet) {
            this.allProperties.get(theProperty).add(s);
            if (this.allSets.contains(s)) continue;
            this.addSet(s);
        }
        return this;
    }

    public ControllerProperties copy(ControllerInterface<?> theController, String ... theSet) {
        HashSet<ControllerProperty> set = this.getPropertySet(theController);
        for (ControllerProperty cp : set) {
            this.copy(cp, theSet);
        }
        return this;
    }

    public ControllerProperties remove(ControllerProperty theProperty, String ... theSet) {
        if (!this.exists(theProperty)) {
            return this;
        }
        for (String s : theSet) {
            this.allProperties.get(theProperty).remove(s);
        }
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> theController, String ... theSet) {
        HashSet<ControllerProperty> set = this.getPropertySet(theController);
        for (ControllerProperty cp : set) {
            this.remove(cp, theSet);
        }
        return this;
    }

    public ControllerProperties only(ControllerProperty theProperty, String theSet) {
        this.allProperties.get(theProperty).clear();
        this.allProperties.get(theProperty).add(theSet);
        return this;
    }

    ControllerProperties only(ControllerInterface<?> theController, String ... theSet) {
        return this;
    }

    private boolean exists(ControllerProperty theProperty) {
        return this.allProperties.containsKey(theProperty);
    }

    public ControllerProperties print() {
        for (Map.Entry<ControllerProperty, HashSet<String>> entry : this.allProperties.entrySet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
        }
        return this;
    }

    public ControllerProperties delete(ControllerProperty theProperty) {
        if (!this.exists(theProperty)) {
            return this;
        }
        this.allProperties.remove(theProperty);
        return this;
    }

    private boolean updatePropertyValue(ControllerProperty theProperty) {
        try {
            Method method = theProperty.getController().getClass().getMethod(theProperty.getGetter(), new Class[0]);
            Object value = method.invoke(theProperty.getController(), new Object[0]);
            theProperty.setType(method.getReturnType());
            theProperty.setValue(value);
            if (this.checkSerializable(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.severe("" + e);
        }
        return false;
    }

    private boolean checkSerializable(Object theProperty) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(theProperty);
            stream.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ControllerProperties setSnapshot(String theKey) {
        HashSet<ControllerProperty> l = new HashSet<ControllerProperty>();
        for (ControllerProperty cp : this.allProperties.keySet()) {
            this.updatePropertyValue(cp);
            try {
                l.add((ControllerProperty)cp.clone());
            }
            catch (CloneNotSupportedException e) {}
        }
        this._mySnapshots.put(theKey, l);
        return this;
    }

    public ControllerProperties updateSnapshot(String theKey) {
        return this.setSnapshot(theKey);
    }

    public ControllerProperties removeSnapshot(String theKey) {
        this._mySnapshots.remove(theKey);
        return this;
    }

    ControllerProperties setSnapshot(String theKey, String ... theSets) {
        return this;
    }

    public ControllerProperties saveSnapshot(String theKey) {
        this.saveSnapshotAs(this.controlP5.papplet.sketchPath(theKey), theKey);
        return this;
    }

    public ControllerProperties saveSnapshotAs(String thePropertiesPath, String theKey) {
        Set<ControllerProperty> log = this._mySnapshots.get(theKey);
        if (log == null) {
            return this;
        }
        thePropertiesPath = this.controlP5.checkPropertiesPath(thePropertiesPath);
        format.compile(thePropertiesPath, log);
        return this;
    }

    public ControllerProperties getSnapshot(String theKey) {
        Set<ControllerProperty> l = this._mySnapshots.get(theKey);
        if (l != null) {
            for (ControllerProperty cp : l) {
                Controller<?> ci = this.controlP5.getController(cp.getAddress());
                ci = ci == null ? this.controlP5.getGroup(cp.getAddress()) : ci;
                try {
                    Method method = ci.getClass().getMethod(cp.getSetter(), cp.getType());
                    method.setAccessible(true);
                    method.invoke(ci, cp.getValue());
                }
                catch (Exception e) {
                    logger.severe(e.toString());
                }
            }
        }
        return this;
    }

    public ArrayList<String> getSnapshotIndices() {
        return new ArrayList<String>(this._mySnapshots.keySet());
    }

    public boolean load() {
        return this.load(this.controlP5.papplet.sketchPath(defaultName + "." + ControllerProperties.format.extension));
    }

    public boolean load(String thePropertiesPath) {
        thePropertiesPath = this.controlP5.checkPropertiesPath(thePropertiesPath);
        for (Format myFormat : Format.values()) {
            if (!thePropertiesPath.toLowerCase().endsWith(myFormat.extension)) continue;
            return myFormat.get().load(thePropertiesPath);
        }
        return false;
    }

    public void setFormat(Format theFormatId) {
        format = theFormatId;
    }

    public boolean save() {
        System.out.println("saving with format " + (Object)((Object)format) + " (" + ControllerProperties.format.extension + ") " + this.controlP5.papplet.sketchPath(defaultName));
        format.compile(this.controlP5.papplet.sketchPath(defaultName), this.allProperties.keySet());
        return true;
    }

    public boolean saveAs(String thePropertiesPath) {
        thePropertiesPath = this.controlP5.checkPropertiesPath(thePropertiesPath);
        format.compile(thePropertiesPath, this.allProperties.keySet());
        return true;
    }

    public boolean saveAs(String thePropertiesPath, String ... theSets) {
        thePropertiesPath = this.controlP5.checkPropertiesPath(thePropertiesPath);
        HashSet<ControllerProperty> sets = new HashSet<ControllerProperty>();
        for (ControllerProperty p : this.allProperties.keySet()) {
            if (!this.allProperties.containsKey(p)) continue;
            HashSet<String> set = this.allProperties.get(p);
            for (String str : set) {
                for (String s : theSets) {
                    if (!str.equals(s)) continue;
                    sets.add(p);
                }
            }
        }
        format.compile(thePropertiesPath, sets);
        return true;
    }

    public String toString() {
        String s = "";
        s = s + this.getClass().getName() + "\n";
        s = s + "total num of properties:\t" + this.allProperties.size() + "\n";
        for (ControllerProperty c : this.allProperties.keySet()) {
            s = s + "\t" + c + "\n";
        }
        s = s + "total num of sets:\t\t" + this.allSets.size() + "\n";
        for (String set : this.allSets) {
            s = s + "\t" + set + "\n";
        }
        return s;
    }

    static {
        logger = Logger.getLogger(ControllerProperties.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SerializedFormat
    implements PropertiesStorageFormat {
        SerializedFormat() {
        }

        @Override
        public boolean load(String thePropertiesPath) {
            try {
                FileInputStream fis = new FileInputStream(thePropertiesPath);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int size = ois.readInt();
                logger.info("loading " + size + " property-items.");
                for (int i = 0; i < size; ++i) {
                    try {
                        ControllerProperty cp = (ControllerProperty)ois.readObject();
                        Controller<?> ci = ControllerProperties.this.controlP5.getController(cp.getAddress());
                        ci = ci == null ? ControllerProperties.this.controlP5.getGroup(cp.getAddress()) : ci;
                        ci.setId(cp.getId());
                        try {
                            Method method = ci.getClass().getMethod(cp.getSetter(), cp.getType());
                            method.setAccessible(true);
                            method.invoke(ci, cp.getValue());
                        }
                        catch (Exception e) {
                            logger.severe(e.toString());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        logger.warning("skipping a property, " + e);
                    }
                }
                ois.close();
            }
            catch (Exception e) {
                logger.warning("Exception during deserialization: " + e);
                return false;
            }
            return true;
        }

        @Override
        public void compile(Set<ControllerProperty> theProperties, String thePropertiesPath) {
            int active = 0;
            int total = 0;
            HashSet<ControllerProperty> propertiesToBeSaved = new HashSet<ControllerProperty>();
            for (ControllerProperty cp : theProperties) {
                if (cp.isActive() && ControllerProperties.this.updatePropertyValue(cp)) {
                    ++active;
                    cp.setId(cp.getController().getId());
                    propertiesToBeSaved.add(cp);
                }
                ++total;
            }
            int ignored = total - active;
            try {
                FileOutputStream fos = new FileOutputStream(thePropertiesPath);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                logger.info("Saving property-items to " + thePropertiesPath);
                oos.writeInt(active);
                for (ControllerProperty cp : propertiesToBeSaved) {
                    if (!cp.isActive()) continue;
                    oos.writeObject(cp);
                }
                logger.info(active + " items saved, " + ignored + " items ignored. Done saving properties.");
                oos.flush();
                oos.close();
                fos.close();
            }
            catch (Exception e) {
                logger.warning("Exception during serialization: " + e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JSONFormat
    implements PropertiesStorageFormat {
        JSONFormat() {
        }

        @Override
        public void compile(Set<ControllerProperty> theProperties, String thePropertiesPath) {
            System.out.println("Dont use the JSONFormat yet, it is not fully implemented with 0.5.9, use SERIALIZED instead.");
            System.out.println("Compiling with JSONFormat");
        }

        @Override
        public boolean load(String thePropertiesPath) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class XMLFormat
    implements PropertiesStorageFormat {
        XMLFormat() {
        }

        @Override
        public void compile(Set<ControllerProperty> theProperties, String thePropertiesPath) {
            System.out.println("Dont use the XMLFormat yet, it is not fully implemented with 0.5.9, use SERIALIZED instead.");
            System.out.println("Compiling with XMLFormat");
            StringBuffer xml = new StringBuffer();
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            xml.append("<properties name=\"" + thePropertiesPath + "\">\n");
            for (ControllerProperty cp : theProperties) {
                if (!cp.isActive()) continue;
                ControllerProperties.this.updatePropertyValue(cp);
                xml.append(this.getXML(cp));
            }
            xml.append("</properties>");
            ((ControllerProperties)ControllerProperties.this).controlP5.papplet.saveStrings(thePropertiesPath, PApplet.split((String)xml.toString(), (String)"\n"));
            System.out.println("saving xml, " + thePropertiesPath);
        }

        @Override
        public boolean load(String thePropertiesPath) {
            String s;
            try {
                s = PApplet.join((String[])((ControllerProperties)ControllerProperties.this).controlP5.papplet.loadStrings(thePropertiesPath), (String)"\n");
            }
            catch (Exception e) {
                logger.warning(thePropertiesPath + ", file not found.");
                return false;
            }
            System.out.println("loading xml \n" + s);
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(s));
                Document doc = db.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nodeLst = doc.getElementsByTagName("property");
                for (int i = 0; i < nodeLst.getLength(); ++i) {
                    Node node = nodeLst.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element fstElmnt = (Element)node;
                    String myAddress = this.getElement(fstElmnt, "address");
                    String mySetter = this.getElement(fstElmnt, "setter");
                    String myType = this.getElement(fstElmnt, "type");
                    String myValue = this.getElement(fstElmnt, "value");
                    try {
                        System.out.print("setting controller " + myAddress + "   ");
                        Controller<?> ci = ControllerProperties.this.controlP5.getController(myAddress);
                        ci = ci == null ? ControllerProperties.this.controlP5.getGroup(myAddress) : ci;
                        System.out.println(ci);
                        try {
                            Class<?> c = this.getClass(myType);
                            System.out.println(myType + " / " + c);
                            Method method = ci.getClass().getMethod(mySetter, c);
                            method.setAccessible(true);
                            method.invoke(ci, this.getValue(myValue, myType, c));
                        }
                        catch (Exception e) {
                            logger.severe(e.toString());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        logger.warning("skipping a property, " + e);
                    }
                }
            }
            catch (SAXException e) {
                logger.warning("SAXException, " + e);
                return false;
            }
            catch (IOException e) {
                logger.warning("IOException, " + e);
                return false;
            }
            catch (ParserConfigurationException e) {
                logger.warning("ParserConfigurationException, " + e);
                return false;
            }
            return true;
        }

        private Object getValue(String theValue, String theType, Class<?> theClass) {
            if (theClass == Integer.TYPE) {
                return Integer.parseInt(theValue);
            }
            if (theClass == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(theValue));
            }
            if (theClass == Boolean.TYPE) {
                return Boolean.parseBoolean(theValue);
            }
            if (theClass.isArray()) {
                System.out.println("this is an array: " + theType + ", " + theValue + ", " + theClass);
                for (int dim = 0; theType.charAt(dim) == '[' && dim < theType.length(); ++dim) {
                }
            } else {
                System.out.println("is array? " + theClass.isArray());
            }
            return theValue;
        }

        private Class<?> getClass(String theType) {
            if (theType.equals("int")) {
                return Integer.TYPE;
            }
            if (theType.equals("float")) {
                return Float.TYPE;
            }
            if (theType.equals("String")) {
                return String.class;
            }
            try {
                return Class.forName(theType);
            }
            catch (ClassNotFoundException e) {
                logger.warning("ClassNotFoundException, " + e);
                return null;
            }
        }

        private String getElement(Element theElement, String theName) {
            NodeList fstNmElmntLst = theElement.getElementsByTagName(theName);
            Element fstNmElmnt = (Element)fstNmElmntLst.item(0);
            NodeList fstNm = fstNmElmnt.getChildNodes();
            return fstNm.item(0).getNodeValue();
        }

        public String getXML(ControllerProperty theProperty) {
            String s = "\t<property>\n";
            s = s + "\t\t<address>" + theProperty.getAddress() + "</address>\n";
            s = s + "\t\t<class>" + ControlP5IOHandler.formatGetClass(theProperty.getController().getClass()) + "</class>\n";
            s = s + "\t\t<setter>" + theProperty.getSetter() + "</setter>\n";
            s = s + "\t\t<getter>" + theProperty.getGetter() + "</getter>\n";
            s = s + "\t\t<type>" + ControlP5IOHandler.formatGetClass(theProperty.getType()) + "</type>\n";
            s = s + "\t\t<value>" + this.cdata(0, theProperty.getValue().getClass()) + (theProperty.getValue().getClass().isArray() ? ControlP5IOHandler.arrayToString(theProperty.getValue()) : theProperty.getValue()) + this.cdata(1, theProperty.getValue().getClass()) + "</value>\n";
            s = s + "\t</property>\n";
            return s;
        }

        private String cdata(int a, Class<?> c) {
            if (c == String.class || c.isArray()) {
                return a == 0 ? "<![CDATA[" : "]]>";
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PropertiesStorageFormat {
        public void compile(Set<ControllerProperty> var1, String var2);

        public boolean load(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        SERIALIZED("ser"),
        XML("xml"),
        JSON("json");

        final String extension;
        PropertiesStorageFormat format;

        private Format(String theExtension) {
            this.extension = theExtension;
        }

        protected void set(PropertiesStorageFormat theStorageFormat) {
            this.format = theStorageFormat;
        }

        protected PropertiesStorageFormat get() {
            return this.format;
        }

        protected void compile(String thePropertiesPath, Set<ControllerProperty> theProperties) {
            if (!thePropertiesPath.endsWith("." + this.extension)) {
                thePropertiesPath = thePropertiesPath + "." + this.extension;
            }
            this.get().compile(theProperties, thePropertiesPath);
        }
    }
}

