/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlKey;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlWindow;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlWindowKeyHandler
implements ControlP5Constants {
    private ControlWindow _myMasterControlWindow;
    public boolean isShiftDown = false;
    public boolean isKeyDown = false;
    boolean isAltDown = false;
    public boolean isCommandDown = false;
    protected char key = (char)32;
    protected int keyCode = -1;
    private Map<KeyCode, List<ControlKey>> keymap = new HashMap<KeyCode, List<ControlKey>>();
    private boolean[] keys = new boolean[525];
    private int numOfActiveKeys = 0;

    public ControlWindowKeyHandler(ControlP5 theControlP5) {
        this._myMasterControlWindow = theControlP5.controlWindow;
    }

    public void update(ControlWindow theControlWindow) {
        this._myMasterControlWindow = theControlWindow;
    }

    public boolean isAltDown() {
        return this.isAltDown;
    }

    public void clear() {
        this.keys = new boolean[525];
        this.numOfActiveKeys = 0;
    }

    public void keyEvent(KeyEvent theKeyEvent, ControlWindow theControlWindow, boolean isMasterWindow) {
        if (theKeyEvent.getID() == 401) {
            if (this.keys[theKeyEvent.getKeyCode()]) {
                return;
            }
            this.keys[theKeyEvent.getKeyCode()] = true;
            ++this.numOfActiveKeys;
            switch (theKeyEvent.getKeyCode()) {
                case 16: {
                    if (this._myMasterControlWindow.controlP5.isShortcuts()) {
                        this.isShiftDown = true;
                        break;
                    }
                    this.isShiftDown = false;
                    break;
                }
                case 18: {
                    if (this._myMasterControlWindow.controlP5.isShortcuts()) {
                        this.isAltDown = true;
                        break;
                    }
                    this.isAltDown = false;
                    break;
                }
                case 157: {
                    this.isCommandDown = this._myMasterControlWindow.controlP5.isShortcuts();
                }
            }
            this.key = theKeyEvent.getKeyChar();
            this.keyCode = theKeyEvent.getKeyCode();
            this.isKeyDown = true;
        }
        if (theKeyEvent.getID() == 402) {
            this.keys[theKeyEvent.getKeyCode()] = false;
            --this.numOfActiveKeys;
            switch (theKeyEvent.getKeyCode()) {
                case 16: {
                    this.isShiftDown = false;
                    break;
                }
                case 18: {
                    this.isAltDown = false;
                    break;
                }
                case 157: {
                    this.isCommandDown = false;
                }
            }
            this.isKeyDown = false;
        }
        if (theKeyEvent.getID() == 401 && this._myMasterControlWindow.controlP5.isShortcuts()) {
            int n = 0;
            for (boolean b : this.keys) {
                n += b ? 1 : 0;
            }
            char[] c = new char[n];
            n = 0;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!this.keys[i]) continue;
                c[n++] = (char)i;
            }
            KeyCode code = new KeyCode(c);
            if (this.keymap.containsKey(code)) {
                for (ControlKey ck : this.keymap.get(code)) {
                    ck.keyEvent();
                }
            }
        }
        if (theControlWindow != null) {
            theControlWindow.keyEvent(theKeyEvent);
        }
    }

    public void reset() {
        this.isShiftDown = false;
        this.isKeyDown = false;
        this.isAltDown = false;
        this.isCommandDown = false;
    }

    public void mapKeyFor(ControlKey theKey, char ... theChar) {
        KeyCode kc = new KeyCode(theChar);
        if (!this.keymap.containsKey(kc)) {
            this.keymap.put(kc, new ArrayList());
        }
        this.keymap.get(kc).add(theKey);
    }

    public void removeKeyFor(ControlKey theKey, char ... theChar) {
        List<ControlKey> l = this.keymap.get(new KeyCode(theChar));
        if (l != null) {
            l.remove(theKey);
        }
    }

    public void removeKeysFor(char ... theChar) {
        this.keymap.remove(new KeyCode(theChar));
    }

    class KeyCode {
        final char[] chars;

        KeyCode(char ... theChars) {
            this.chars = theChars;
            Arrays.sort(this.chars);
        }

        public int size() {
            return this.chars.length;
        }

        public char[] getChars() {
            return this.chars;
        }

        public char get(int theIndex) {
            if (theIndex >= 0 && theIndex < this.size()) {
                return this.chars[theIndex];
            }
            return '\u0000';
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyCode)) {
                return false;
            }
            KeyCode k = (KeyCode)obj;
            if (k.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == k.get(i)) continue;
                return false;
            }
            return true;
        }

        boolean contains(char n) {
            for (char c : this.chars) {
                if (n != c) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            int n = 1;
            for (char c : this.chars) {
                hashCode = (int)((double)hashCode + ((double)c + Math.pow(c, n++)));
            }
            return hashCode;
        }
    }
}

