library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity SUM4B is
    Port ( a : in  STD_LOGIC_VECTOR (3 downto 0);
           b : in  STD_LOGIC_VECTOR (3 downto 0);
           cin : in  STD_LOGIC;
           cout : out  STD_LOGIC;
           y : out  STD_LOGIC_VECTOR (3 downto 0));
end SUM4B;

architecture Behavioral of SUM4B is
component adder is
    
Port ( cin : in  STD_LOGIC;
           
a : in  STD_LOGIC;
           
b : in  STD_LOGIC;
           
y : out  STD_LOGIC;
           
cout : out  STD_LOGIC);

end component;

signal ct:std_logic_vector(2 downto 0);

begin

s0:adder port map (a=>a(0), b=>b(0), cin => cin, y=>y(0), cout=>ct(0));

s1:adder port map (a=>a(1), b=>b(1), cin => ct(0), y=>y(1), cout=>ct(1));

s2:adder port map (a=>a(2), b=>b(2), cin => ct(1), y=>y(2), cout=>ct(2));

s3:adder port map (a=>a(3), b=>b(3), cin => ct(2), y=>y(3), cout=>cout);

end Behavioral;

